/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.gerrit.server.config.GerritServerConfig;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.jgit.lib.Config;

@Singleton
public class ThreadSettingsConfig {
    private final int sshdThreads;
    private final int httpdMaxThreads;
    private final int sshdBatchThreads;
    private final int databasePoolLimit;

    @Inject
    ThreadSettingsConfig(@GerritServerConfig Config cfg) {
        int cores = Runtime.getRuntime().availableProcessors();
        this.sshdThreads = cfg.getInt("sshd", "threads", 2 * cores);
        this.httpdMaxThreads = cfg.getInt("httpd", "maxThreads", 25);
        int defaultDatabasePoolLimit = this.sshdThreads + this.httpdMaxThreads + 2;
        this.databasePoolLimit = cfg.getInt("database", "poolLimit", defaultDatabasePoolLimit);
        this.sshdBatchThreads = cores == 1 ? 1 : 2;
    }

    public int getDatabasePoolLimit() {
        return this.databasePoolLimit;
    }

    public int getHttpdMaxThreads() {
        return this.httpdMaxThreads;
    }

    public int getSshdThreads() {
        return this.sshdThreads;
    }

    public int getSshdBatchTreads() {
        return this.sshdBatchThreads;
    }
}

