/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.events;

import com.google.common.base.Supplier;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.client.RefNames;
import com.google.gerrit.server.data.ChangeAttribute;
import com.google.gerrit.server.events.RefEvent;

public abstract class ChangeEvent
extends RefEvent {
    public Supplier<ChangeAttribute> change;
    public Project.NameKey project;
    public String refName;
    public Change.Key changeKey;

    protected ChangeEvent(String type, Change change) {
        super(type);
        this.project = change.getProject();
        this.refName = RefNames.fullName(change.getDest().get());
        this.changeKey = change.getKey();
    }

    @Override
    public Project.NameKey getProjectNameKey() {
        return this.project;
    }

    @Override
    public String getRefName() {
        return this.refName;
    }

    public Change.Key getChangeKey() {
        return this.changeKey;
    }
}

