/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.events;

import com.google.gerrit.server.events.AssigneeChangedEvent;
import com.google.gerrit.server.events.ChangeAbandonedEvent;
import com.google.gerrit.server.events.ChangeMergedEvent;
import com.google.gerrit.server.events.ChangeRestoredEvent;
import com.google.gerrit.server.events.CommentAddedEvent;
import com.google.gerrit.server.events.CommitReceivedEvent;
import com.google.gerrit.server.events.DraftPublishedEvent;
import com.google.gerrit.server.events.Event;
import com.google.gerrit.server.events.HashtagsChangedEvent;
import com.google.gerrit.server.events.PatchSetCreatedEvent;
import com.google.gerrit.server.events.ProjectCreatedEvent;
import com.google.gerrit.server.events.RefReceivedEvent;
import com.google.gerrit.server.events.RefUpdatedEvent;
import com.google.gerrit.server.events.ReviewerAddedEvent;
import com.google.gerrit.server.events.ReviewerDeletedEvent;
import com.google.gerrit.server.events.TopicChangedEvent;
import com.google.gerrit.server.events.VoteDeletedEvent;
import java.util.HashMap;
import java.util.Map;

public class EventTypes {
    private static final Map<String, Class<?>> typesByString = new HashMap();

    public static void register(String eventType, Class<? extends Event> eventClass) {
        typesByString.put(eventType, eventClass);
    }

    public static Class<?> getClass(String type) {
        return typesByString.get(type);
    }

    static {
        EventTypes.register("assignee-changed", AssigneeChangedEvent.class);
        EventTypes.register("change-abandoned", ChangeAbandonedEvent.class);
        EventTypes.register("change-merged", ChangeMergedEvent.class);
        EventTypes.register("change-restored", ChangeRestoredEvent.class);
        EventTypes.register("comment-added", CommentAddedEvent.class);
        EventTypes.register("commit-received", CommitReceivedEvent.class);
        EventTypes.register("draft-published", DraftPublishedEvent.class);
        EventTypes.register("hashtags-changed", HashtagsChangedEvent.class);
        EventTypes.register("patchset-created", PatchSetCreatedEvent.class);
        EventTypes.register("project-created", ProjectCreatedEvent.class);
        EventTypes.register("ref-received", RefReceivedEvent.class);
        EventTypes.register("ref-updated", RefUpdatedEvent.class);
        EventTypes.register("reviewer-added", ReviewerAddedEvent.class);
        EventTypes.register("reviewer-deleted", ReviewerDeletedEvent.class);
        EventTypes.register("topic-changed", TopicChangedEvent.class);
        EventTypes.register("vote-deleted", VoteDeletedEvent.class);
    }
}

