/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.config.ConfigUtil;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.git.MultiProgressMonitor;
import com.google.gerrit.server.git.ProjectRunnable;
import com.google.gerrit.server.git.ReceiveCommits;
import com.google.gerrit.server.git.ReceiveCommitsExecutor;
import com.google.gerrit.server.git.WorkQueue;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.util.RequestScopePropagator;
import com.google.inject.Inject;
import com.google.inject.PrivateModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.name.Named;
import java.io.OutputStream;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.PreReceiveHook;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.transport.ReceivePack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncReceiveCommits
implements PreReceiveHook {
    private static final Logger log = LoggerFactory.getLogger(AsyncReceiveCommits.class);
    private static final String TIMEOUT_NAME = "ReceiveCommitsOverallTimeout";
    private final ReceiveCommits rc;
    private final WorkQueue.Executor executor;
    private final RequestScopePropagator scopePropagator;
    private final MultiProgressMonitor progress;
    private final long timeoutMillis;

    @Inject
    AsyncReceiveCommits(ReceiveCommits.Factory factory, @ReceiveCommitsExecutor WorkQueue.Executor executor, RequestScopePropagator scopePropagator, @Named(value="ReceiveCommitsOverallTimeout") long timeoutMillis, @Assisted ProjectControl projectControl, @Assisted Repository repo) {
        this.executor = executor;
        this.scopePropagator = scopePropagator;
        this.rc = factory.create(projectControl, repo);
        this.rc.getReceivePack().setPreReceiveHook(this);
        this.progress = new MultiProgressMonitor(new MessageSenderOutputStream(), "Processing changes");
        this.timeoutMillis = timeoutMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPreReceive(ReceivePack rp, Collection<ReceiveCommand> commands) {
        try {
            this.progress.waitFor(this.executor.submit(this.scopePropagator.wrap(new Worker(commands))), this.timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            log.warn("Error in ReceiveCommits while processing changes for project {}", (Object)this.rc.getProject().getName(), (Object)e);
            this.rc.addError("internal error while processing changes");
            for (ReceiveCommand c : commands) {
                if (c.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) continue;
                c.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, "internal error");
            }
        }
        finally {
            this.rc.sendMessages();
        }
    }

    public ReceiveCommits getReceiveCommits() {
        return this.rc;
    }

    private class MessageSenderOutputStream
    extends OutputStream {
        private MessageSenderOutputStream() {
        }

        @Override
        public void write(int b) {
            AsyncReceiveCommits.this.rc.getMessageSender().sendBytes(new byte[]{(byte)b});
        }

        @Override
        public void write(byte[] what, int off, int len) {
            AsyncReceiveCommits.this.rc.getMessageSender().sendBytes(what, off, len);
        }

        @Override
        public void write(byte[] what) {
            AsyncReceiveCommits.this.rc.getMessageSender().sendBytes(what);
        }

        @Override
        public void flush() {
            AsyncReceiveCommits.this.rc.getMessageSender().flush();
        }
    }

    private class Worker
    implements ProjectRunnable {
        private final Collection<ReceiveCommand> commands;

        private Worker(Collection<ReceiveCommand> commands) {
            this.commands = commands;
        }

        @Override
        public void run() {
            AsyncReceiveCommits.this.rc.processCommands(this.commands, AsyncReceiveCommits.this.progress);
        }

        @Override
        public Project.NameKey getProjectNameKey() {
            return AsyncReceiveCommits.this.rc.getProject().getNameKey();
        }

        @Override
        public String getRemoteName() {
            return null;
        }

        @Override
        public boolean hasCustomizedPrint() {
            return true;
        }

        public String toString() {
            return "receive-commits";
        }
    }

    public static class Module
    extends PrivateModule {
        @Override
        public void configure() {
            this.install(new FactoryModuleBuilder().build(Factory.class));
            this.expose(Factory.class);
            this.install(new FactoryModuleBuilder().build(ReceiveCommits.Factory.class));
        }

        @Provides
        @Singleton
        @Named(value="ReceiveCommitsOverallTimeout")
        long getTimeoutMillis(@GerritServerConfig Config cfg) {
            return ConfigUtil.getTimeUnit(cfg, "receive", null, "timeout", TimeUnit.MINUTES.toMillis(4L), TimeUnit.MILLISECONDS);
        }
    }

    public static interface Factory {
        public AsyncReceiveCommits create(ProjectControl var1, Repository var2);
    }
}

