/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.google.gerrit.common.data.SubscribeSection;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.client.SubmoduleSubscription;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.VerboseSuperprojectUpdate;
import com.google.gerrit.server.git.CodeReviewCommit;
import com.google.gerrit.server.git.GitModules;
import com.google.gerrit.server.git.MergeOpRepoManager;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.git.SubmoduleException;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.update.BatchUpdate;
import com.google.gerrit.server.update.BatchUpdateListener;
import com.google.gerrit.server.update.RepoContext;
import com.google.gerrit.server.update.RepoOnlyOp;
import com.google.gerrit.server.update.UpdateException;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.transport.RefSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubmoduleOp {
    private static final Logger log = LoggerFactory.getLogger(SubmoduleOp.class);
    private final GitModules.Factory gitmodulesFactory;
    private final PersonIdent myIdent;
    private final ProjectCache projectCache;
    private final ProjectState.Factory projectStateFactory;
    private final BatchUpdate.Factory batchUpdateFactory;
    private final VerboseSuperprojectUpdate verboseSuperProject;
    private final boolean enableSuperProjectSubscriptions;
    private final MergeOpRepoManager orm;
    private final Map<Branch.NameKey, GitModules> branchGitModules;
    private final Map<Branch.NameKey, CodeReviewCommit> branchTips;
    private final Set<Branch.NameKey> updatedBranches;
    private final Set<Branch.NameKey> affectedBranches;
    private final ImmutableSet<Branch.NameKey> sortedBranches;
    private final SetMultimap<Branch.NameKey, SubmoduleSubscription> targets;
    private final SetMultimap<Project.NameKey, Branch.NameKey> branchesByProject;

    @AssistedInject
    public SubmoduleOp(GitModules.Factory gitmodulesFactory, @GerritPersonIdent PersonIdent myIdent, @GerritServerConfig Config cfg, ProjectCache projectCache, ProjectState.Factory projectStateFactory, BatchUpdate.Factory batchUpdateFactory, @Assisted Set<Branch.NameKey> updatedBranches, @Assisted MergeOpRepoManager orm) throws SubmoduleException {
        this.gitmodulesFactory = gitmodulesFactory;
        this.myIdent = myIdent;
        this.projectCache = projectCache;
        this.projectStateFactory = projectStateFactory;
        this.batchUpdateFactory = batchUpdateFactory;
        this.verboseSuperProject = cfg.getEnum("submodule", null, "verboseSuperprojectUpdate", VerboseSuperprojectUpdate.TRUE);
        this.enableSuperProjectSubscriptions = cfg.getBoolean("submodule", "enableSuperProjectSubscriptions", true);
        this.orm = orm;
        this.updatedBranches = updatedBranches;
        this.targets = MultimapBuilder.hashKeys().hashSetValues().build();
        this.affectedBranches = new HashSet<Branch.NameKey>();
        this.branchTips = new HashMap<Branch.NameKey, CodeReviewCommit>();
        this.branchGitModules = new HashMap<Branch.NameKey, GitModules>();
        this.branchesByProject = MultimapBuilder.hashKeys().hashSetValues().build();
        this.sortedBranches = this.calculateSubscriptionMap();
    }

    private ImmutableSet<Branch.NameKey> calculateSubscriptionMap() throws SubmoduleException {
        if (!this.enableSuperProjectSubscriptions) {
            this.logDebug("Updating superprojects disabled", new Object[0]);
            return null;
        }
        this.logDebug("Calculating superprojects - submodules map", new Object[0]);
        LinkedHashSet<Branch.NameKey> allVisited = new LinkedHashSet<Branch.NameKey>();
        for (Branch.NameKey updatedBranch : this.updatedBranches) {
            if (allVisited.contains(updatedBranch)) continue;
            this.searchForSuperprojects(updatedBranch, new LinkedHashSet<Branch.NameKey>(), allVisited);
        }
        allVisited.retainAll(this.affectedBranches);
        SubmoduleOp.reverse(allVisited);
        return ImmutableSet.copyOf(allVisited);
    }

    private void searchForSuperprojects(Branch.NameKey current, LinkedHashSet<Branch.NameKey> currentVisited, LinkedHashSet<Branch.NameKey> allVisited) throws SubmoduleException {
        this.logDebug("Now processing " + current, new Object[0]);
        if (currentVisited.contains(current)) {
            throw new SubmoduleException("Branch level circular subscriptions detected:  " + this.printCircularPath(currentVisited, current));
        }
        if (allVisited.contains(current)) {
            return;
        }
        currentVisited.add(current);
        try {
            Collection<SubmoduleSubscription> subscriptions = this.superProjectSubscriptionsForSubmoduleBranch(current);
            for (SubmoduleSubscription sub : subscriptions) {
                Branch.NameKey superBranch = sub.getSuperProject();
                this.searchForSuperprojects(superBranch, currentVisited, allVisited);
                this.targets.put(superBranch, sub);
                this.branchesByProject.put(superBranch.getParentKey(), superBranch);
                this.affectedBranches.add(superBranch);
                this.affectedBranches.add(sub.getSubmodule());
            }
        }
        catch (IOException e) {
            throw new SubmoduleException("Cannot find superprojects for " + current, e);
        }
        currentVisited.remove(current);
        allVisited.add(current);
    }

    private static <T> void reverse(LinkedHashSet<T> set) {
        if (set == null) {
            return;
        }
        ArrayDeque<T> q = new ArrayDeque<T>(set);
        set.clear();
        while (!q.isEmpty()) {
            set.add(q.removeLast());
        }
    }

    private <T> String printCircularPath(LinkedHashSet<T> p, T target) {
        StringBuilder sb = new StringBuilder();
        sb.append(target);
        ArrayList<T> reverseP = new ArrayList<T>(p);
        Collections.reverse(reverseP);
        for (T t : reverseP) {
            sb.append("->");
            sb.append(t);
            if (!t.equals(target)) continue;
            break;
        }
        return sb.toString();
    }

    private Collection<Branch.NameKey> getDestinationBranches(Branch.NameKey src, SubscribeSection s) throws IOException {
        HashSet<Branch.NameKey> ret = new HashSet<Branch.NameKey>();
        this.logDebug("Inspecting SubscribeSection " + s, new Object[0]);
        for (RefSpec r : s.getMatchingRefSpecs()) {
            this.logDebug("Inspecting [matching] ref " + r, new Object[0]);
            if (!r.matchSource(src.get())) continue;
            if (r.isWildcard()) {
                ret.add(new Branch.NameKey(s.getProject(), r.expandFromSource(src.get()).getDestination()));
                continue;
            }
            String dest = r.getDestination();
            if (dest == null) {
                dest = r.getSource();
            }
            ret.add(new Branch.NameKey(s.getProject(), dest));
        }
        for (RefSpec r : s.getMultiMatchRefSpecs()) {
            MergeOpRepoManager.OpenRepo or;
            this.logDebug("Inspecting [all] ref " + r, new Object[0]);
            if (!r.matchSource(src.get())) continue;
            try {
                or = this.orm.getRepo(s.getProject());
            }
            catch (NoSuchProjectException e) {
                continue;
            }
            for (Ref ref : or.repo.getRefDatabase().getRefs("refs/heads/").values()) {
                Branch.NameKey b;
                if (r.getDestination() != null && !r.matchDestination(ref.getName()) || ret.contains(b = new Branch.NameKey(s.getProject(), ref.getName()))) continue;
                ret.add(b);
            }
        }
        this.logDebug("Returning possible branches: " + ret + "for project " + s.getProject(), new Object[0]);
        return ret;
    }

    public Collection<SubmoduleSubscription> superProjectSubscriptionsForSubmoduleBranch(Branch.NameKey srcBranch) throws IOException {
        this.logDebug("Calculating possible superprojects for " + srcBranch, new Object[0]);
        ArrayList<SubmoduleSubscription> ret = new ArrayList<SubmoduleSubscription>();
        Project.NameKey srcProject = srcBranch.getParentKey();
        ProjectConfig cfg = this.projectCache.get(srcProject).getConfig();
        for (SubscribeSection s : this.projectStateFactory.create(cfg).getSubscribeSections(srcBranch)) {
            this.logDebug("Checking subscribe section " + s, new Object[0]);
            Collection<Branch.NameKey> branches = this.getDestinationBranches(srcBranch, s);
            for (Branch.NameKey targetBranch : branches) {
                block6: {
                    Project.NameKey targetProject = targetBranch.getParentKey();
                    try {
                        MergeOpRepoManager.OpenRepo or = this.orm.getRepo(targetProject);
                        ObjectId id = or.repo.resolve(targetBranch.get());
                        if (id == null) {
                            this.logDebug("The branch " + targetBranch + " doesn't exist.", new Object[0]);
                        }
                        break block6;
                    }
                    catch (NoSuchProjectException e) {
                        this.logDebug("The project " + targetProject + " doesn't exist", new Object[0]);
                    }
                    continue;
                }
                GitModules m = this.branchGitModules.get(targetBranch);
                if (m == null) {
                    m = this.gitmodulesFactory.create(targetBranch, this.orm);
                    this.branchGitModules.put(targetBranch, m);
                }
                ret.addAll(m.subscribedTo(srcBranch));
            }
        }
        this.logDebug("Calculated superprojects for " + srcBranch + " are " + ret, new Object[0]);
        return ret;
    }

    public void updateSuperProjects() throws SubmoduleException {
        ImmutableSet<Project.NameKey> projects = this.getProjectsInOrder();
        if (projects == null) {
            return;
        }
        LinkedHashSet<Project.NameKey> superProjects = new LinkedHashSet<Project.NameKey>();
        try {
            for (Project.NameKey project : projects) {
                if (!this.branchesByProject.containsKey(project)) continue;
                superProjects.add(project);
                MergeOpRepoManager.OpenRepo or = this.orm.getRepo(project);
                for (Branch.NameKey branch : this.branchesByProject.get((Object)project)) {
                    this.addOp(or.getUpdate(), branch);
                }
            }
            this.batchUpdateFactory.execute(this.orm.batchUpdates(superProjects), BatchUpdateListener.NONE, this.orm.getSubmissionId(), false);
        }
        catch (RestApiException | NoSuchProjectException | UpdateException | IOException e) {
            throw new SubmoduleException("Cannot update gitlinks", e);
        }
    }

    public CodeReviewCommit composeGitlinksCommit(Branch.NameKey subscriber) throws IOException, SubmoduleException {
        CodeReviewCommit currentCommit;
        MergeOpRepoManager.OpenRepo or;
        try {
            or = this.orm.getRepo(subscriber.getParentKey());
        }
        catch (NoSuchProjectException | IOException e) {
            throw new SubmoduleException("Cannot access superproject", e);
        }
        if (this.branchTips.containsKey(subscriber)) {
            currentCommit = this.branchTips.get(subscriber);
        } else {
            Ref r = or.repo.exactRef(subscriber.get());
            if (r == null) {
                throw new SubmoduleException("The branch was probably deleted from the subscriber repository");
            }
            currentCommit = or.rw.parseCommit(r.getObjectId());
            this.addBranchTip(subscriber, currentCommit);
        }
        StringBuilder msgbuf = new StringBuilder("");
        PersonIdent author = null;
        DirCache dc = SubmoduleOp.readTree(or.rw, currentCommit);
        DirCacheEditor ed = dc.editor();
        int count = 0;
        for (SubmoduleSubscription s : this.targets.get((Object)subscriber)) {
            if (count > 0) {
                msgbuf.append("\n\n");
            }
            RevCommit newCommit = this.updateSubmodule(dc, ed, msgbuf, s);
            ++count;
            if (newCommit == null) continue;
            if (author == null) {
                author = newCommit.getAuthorIdent();
                continue;
            }
            if (author.equals(newCommit.getAuthorIdent())) continue;
            author = this.myIdent;
        }
        ed.finish();
        ObjectId newTreeId = dc.writeTree(or.ins);
        if (newTreeId.equals(currentCommit.getTree())) {
            return null;
        }
        CommitBuilder commit = new CommitBuilder();
        commit.setTreeId(newTreeId);
        commit.setParentId(currentCommit);
        StringBuilder commitMsg = new StringBuilder("Update git submodules\n\n");
        if (this.verboseSuperProject != VerboseSuperprojectUpdate.FALSE) {
            commitMsg.append((CharSequence)msgbuf);
        }
        commit.setMessage(commitMsg.toString());
        commit.setAuthor(author);
        commit.setCommitter(this.myIdent);
        ObjectId id = or.ins.insert(commit);
        return or.rw.parseCommit(id);
    }

    public CodeReviewCommit composeGitlinksCommit(Branch.NameKey subscriber, CodeReviewCommit currentCommit) throws IOException, SubmoduleException {
        MergeOpRepoManager.OpenRepo or;
        try {
            or = this.orm.getRepo(subscriber.getParentKey());
        }
        catch (NoSuchProjectException | IOException e) {
            throw new SubmoduleException("Cannot access superproject", e);
        }
        StringBuilder msgbuf = new StringBuilder("");
        DirCache dc = SubmoduleOp.readTree(or.rw, currentCommit);
        DirCacheEditor ed = dc.editor();
        for (SubmoduleSubscription s : this.targets.get((Object)subscriber)) {
            this.updateSubmodule(dc, ed, msgbuf, s);
        }
        ed.finish();
        ObjectId newTreeId = dc.writeTree(or.ins);
        if (newTreeId.equals(currentCommit.getTree())) {
            return currentCommit;
        }
        or.rw.parseBody(currentCommit);
        CommitBuilder commit = new CommitBuilder();
        commit.setTreeId(newTreeId);
        commit.setParentIds(currentCommit.getParents());
        if (this.verboseSuperProject != VerboseSuperprojectUpdate.FALSE) {
            commit.setMessage(currentCommit.getFullMessage() + "\n\n* submodules:\n" + msgbuf.toString());
        } else {
            commit.setMessage(currentCommit.getFullMessage());
        }
        commit.setAuthor(currentCommit.getAuthorIdent());
        commit.setCommitter(this.myIdent);
        ObjectId id = or.ins.insert(commit);
        CodeReviewCommit newCommit = or.rw.parseCommit(id);
        newCommit.copyFrom(currentCommit);
        return newCommit;
    }

    private RevCommit updateSubmodule(DirCache dc, DirCacheEditor ed, StringBuilder msgbuf, SubmoduleSubscription s) throws SubmoduleException, IOException {
        CodeReviewCommit newCommit;
        MergeOpRepoManager.OpenRepo subOr;
        try {
            subOr = this.orm.getRepo(s.getSubmodule().getParentKey());
        }
        catch (NoSuchProjectException | IOException e) {
            throw new SubmoduleException("Cannot access submodule", e);
        }
        DirCacheEntry dce = dc.getEntry(s.getPath());
        CodeReviewCommit oldCommit = null;
        if (dce != null) {
            if (!dce.getFileMode().equals(FileMode.GITLINK)) {
                String errMsg = "Requested to update gitlink " + s.getPath() + " in " + s.getSubmodule().getParentKey().get() + " but entry doesn't have gitlink file mode.";
                throw new SubmoduleException(errMsg);
            }
            oldCommit = subOr.rw.parseCommit(dce.getObjectId());
        }
        if (this.branchTips.containsKey(s.getSubmodule())) {
            newCommit = this.branchTips.get(s.getSubmodule());
        } else {
            Ref ref = subOr.repo.getRefDatabase().exactRef(s.getSubmodule().get());
            if (ref == null) {
                ed.add(new DirCacheEditor.DeletePath(s.getPath()));
                return null;
            }
            newCommit = subOr.rw.parseCommit(ref.getObjectId());
            this.addBranchTip(s.getSubmodule(), newCommit);
        }
        if (Objects.equals(newCommit, oldCommit)) {
            return null;
        }
        ed.add(new DirCacheEditor.PathEdit(s.getPath()){

            @Override
            public void apply(DirCacheEntry ent) {
                ent.setFileMode(FileMode.GITLINK);
                ent.setObjectId(newCommit.getId());
            }
        });
        if (this.verboseSuperProject != VerboseSuperprojectUpdate.FALSE) {
            this.createSubmoduleCommitMsg(msgbuf, s, subOr, newCommit, oldCommit);
        }
        subOr.rw.parseBody(newCommit);
        return newCommit;
    }

    private void createSubmoduleCommitMsg(StringBuilder msgbuf, SubmoduleSubscription s, MergeOpRepoManager.OpenRepo subOr, RevCommit newCommit, RevCommit oldCommit) throws SubmoduleException {
        msgbuf.append("* Update " + s.getPath());
        msgbuf.append(" from branch '" + s.getSubmodule().getShortName() + "'");
        msgbuf.append("\n  to " + newCommit.getName());
        if (oldCommit == null) {
            return;
        }
        try {
            subOr.rw.resetRetain(subOr.canMergeFlag);
            subOr.rw.markStart(newCommit);
            subOr.rw.markUninteresting(oldCommit);
            for (RevCommit c : subOr.rw) {
                subOr.rw.parseBody(c);
                if (this.verboseSuperProject == VerboseSuperprojectUpdate.SUBJECT_ONLY) {
                    msgbuf.append("\n  - " + c.getShortMessage());
                    continue;
                }
                if (this.verboseSuperProject != VerboseSuperprojectUpdate.TRUE) continue;
                msgbuf.append("\n  - " + c.getFullMessage().replace("\n", "\n    "));
            }
        }
        catch (IOException e) {
            throw new SubmoduleException("Could not perform a revwalk to create superproject commit message", e);
        }
    }

    private static DirCache readTree(RevWalk rw, ObjectId base) throws IOException {
        DirCache dc = DirCache.newInCore();
        DirCacheBuilder b = dc.builder();
        b.addTree(new byte[0], 0, rw.getObjectReader(), rw.parseTree(base));
        b.finish();
        return dc;
    }

    public ImmutableSet<Project.NameKey> getProjectsInOrder() throws SubmoduleException {
        LinkedHashSet<Project.NameKey> projects = new LinkedHashSet<Project.NameKey>();
        for (Project.NameKey project : this.branchesByProject.keySet()) {
            this.addAllSubmoduleProjects(project, new LinkedHashSet<Project.NameKey>(), projects);
        }
        for (Branch.NameKey branch : this.updatedBranches) {
            projects.add(branch.getParentKey());
        }
        return ImmutableSet.copyOf(projects);
    }

    private void addAllSubmoduleProjects(Project.NameKey project, LinkedHashSet<Project.NameKey> current, LinkedHashSet<Project.NameKey> projects) throws SubmoduleException {
        if (current.contains(project)) {
            throw new SubmoduleException("Project level circular subscriptions detected:  " + this.printCircularPath(current, project));
        }
        if (projects.contains(project)) {
            return;
        }
        current.add(project);
        HashSet<Project.NameKey> subprojects = new HashSet<Project.NameKey>();
        for (Branch.NameKey branch : this.branchesByProject.get((Object)project)) {
            Collection subscriptions = this.targets.get((Object)branch);
            for (SubmoduleSubscription s : subscriptions) {
                subprojects.add(s.getSubmodule().getParentKey());
            }
        }
        for (Project.NameKey p : subprojects) {
            this.addAllSubmoduleProjects(p, current, projects);
        }
        current.remove(project);
        projects.add(project);
    }

    public ImmutableSet<Branch.NameKey> getBranchesInOrder() {
        LinkedHashSet<Branch.NameKey> branches = new LinkedHashSet<Branch.NameKey>();
        if (this.sortedBranches != null) {
            branches.addAll(this.sortedBranches);
        }
        branches.addAll(this.updatedBranches);
        return ImmutableSet.copyOf(branches);
    }

    public boolean hasSubscription(Branch.NameKey branch) {
        return this.targets.containsKey(branch);
    }

    public void addBranchTip(Branch.NameKey branch, CodeReviewCommit tip) {
        this.branchTips.put(branch, tip);
    }

    public void addOp(BatchUpdate bu, Branch.NameKey branch) {
        bu.addRepoOnlyOp(new GitlinkOp(branch));
    }

    private void logDebug(String msg, Object ... args) {
        if (log.isDebugEnabled()) {
            log.debug(this.orm.getSubmissionId() + msg, args);
        }
    }

    public static interface Factory {
        public SubmoduleOp create(Set<Branch.NameKey> var1, MergeOpRepoManager var2);
    }

    public class GitlinkOp
    implements RepoOnlyOp {
        private final Branch.NameKey branch;

        GitlinkOp(Branch.NameKey branch) {
            this.branch = branch;
        }

        @Override
        public void updateRepo(RepoContext ctx) throws Exception {
            CodeReviewCommit c = SubmoduleOp.this.composeGitlinksCommit(this.branch);
            if (c != null) {
                ctx.addRefUpdate(new ReceiveCommand(c.getParent(0), c, this.branch.get()));
                SubmoduleOp.this.addBranchTip(this.branch, c);
            }
        }
    }
}

