/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.index;

import com.google.common.primitives.Ints;
import com.google.gerrit.server.config.SitePaths;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;

public class GerritIndexStatus {
    private static final String SECTION = "index";
    private static final String KEY_READY = "ready";
    private final FileBasedConfig cfg;

    public GerritIndexStatus(SitePaths sitePaths) throws ConfigInvalidException, IOException {
        this.cfg = new FileBasedConfig(sitePaths.index_dir.resolve("gerrit_index.config").toFile(), FS.detect());
        this.cfg.load();
        this.convertLegacyConfig();
    }

    public void setReady(String indexName, int version, boolean ready) {
        this.cfg.setBoolean(SECTION, GerritIndexStatus.indexDirName(indexName, version), KEY_READY, ready);
    }

    public boolean getReady(String indexName, int version) {
        return this.cfg.getBoolean(SECTION, GerritIndexStatus.indexDirName(indexName, version), KEY_READY, false);
    }

    public void save() throws IOException {
        this.cfg.save();
    }

    private void convertLegacyConfig() throws IOException {
        boolean dirty = false;
        for (String subsection : this.cfg.getSubsections(SECTION)) {
            String ready;
            Integer v = Ints.tryParse(subsection);
            if (v == null || (ready = this.cfg.getString(SECTION, subsection, KEY_READY)) == null) continue;
            dirty = false;
            this.cfg.unset(SECTION, subsection, KEY_READY);
            this.cfg.setString(SECTION, GerritIndexStatus.indexDirName("changes", v), KEY_READY, ready);
        }
        if (dirty) {
            this.cfg.save();
        }
    }

    private static String indexDirName(String indexName, int version) {
        return String.format("%s_%04d", indexName, version);
    }
}

