/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.index.account;

import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountState;
import com.google.gerrit.server.git.QueueProvider;
import com.google.gerrit.server.index.IndexExecutor;
import com.google.gerrit.server.index.SiteIndexer;
import com.google.gerrit.server.index.account.AccountIndex;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AllAccountsIndexer
extends SiteIndexer<Account.Id, AccountState, AccountIndex> {
    private static final Logger log = LoggerFactory.getLogger(AllAccountsIndexer.class);
    private final SchemaFactory<ReviewDb> schemaFactory;
    private final ListeningExecutorService executor;
    private final AccountCache accountCache;

    @Inject
    AllAccountsIndexer(SchemaFactory<ReviewDb> schemaFactory, @IndexExecutor(value=QueueProvider.QueueType.BATCH) ListeningExecutorService executor, AccountCache accountCache) {
        this.schemaFactory = schemaFactory;
        this.executor = executor;
        this.accountCache = accountCache;
    }

    @Override
    public SiteIndexer.Result indexAll(AccountIndex index) {
        List<Account.Id> ids;
        TextProgressMonitor progress = new TextProgressMonitor(new PrintWriter(this.progressOut));
        progress.start(2);
        Stopwatch sw = Stopwatch.createStarted();
        try {
            ids = this.collectAccounts(progress);
        }
        catch (OrmException e) {
            log.error("Error collecting accounts", e);
            return new SiteIndexer.Result(sw, false, 0, 0);
        }
        return this.reindexAccounts(index, ids, progress);
    }

    private SiteIndexer.Result reindexAccounts(final AccountIndex index, List<Account.Id> ids, ProgressMonitor progress) {
        progress.beginTask("Reindexing accounts", ids.size());
        ArrayList<Future> futures = new ArrayList<Future>(ids.size());
        AtomicBoolean ok = new AtomicBoolean(true);
        final AtomicInteger done = new AtomicInteger();
        final AtomicInteger failed = new AtomicInteger();
        Stopwatch sw = Stopwatch.createStarted();
        for (final Account.Id id : ids) {
            final String desc = "account " + id;
            Future future = this.executor.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        AllAccountsIndexer.this.accountCache.evict(id);
                        index.replace(AllAccountsIndexer.this.accountCache.get(id));
                        AllAccountsIndexer.this.verboseWriter.println("Reindexed " + desc);
                        done.incrementAndGet();
                    }
                    catch (Exception e) {
                        failed.incrementAndGet();
                        throw e;
                    }
                    return null;
                }
            });
            this.addErrorListener((ListenableFuture<?>)future, desc, progress, ok);
            futures.add(future);
        }
        try {
            Futures.successfulAsList(futures).get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("Error waiting on account futures", e);
            return new SiteIndexer.Result(sw, false, 0, 0);
        }
        progress.endTask();
        return new SiteIndexer.Result(sw, ok.get(), done.get(), failed.get());
    }

    private List<Account.Id> collectAccounts(ProgressMonitor progress) throws OrmException {
        progress.beginTask("Collecting accounts", 0);
        ArrayList<Account.Id> ids = new ArrayList<Account.Id>();
        try (ReviewDb db = this.schemaFactory.open();){
            for (Account account : db.accounts().all()) {
                ids.add(account.getId());
            }
        }
        progress.endTask();
        return ids;
    }
}

