/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.mail.receive;

import com.google.gerrit.reviewdb.client.Comment;
import java.util.StringJoiner;
import java.util.regex.Pattern;

public class ParserUtil {
    private static final Pattern SIMPLE_EMAIL_PATTERN = Pattern.compile("[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})");

    public static String trimQuotation(String comment) {
        String lastLines;
        StringJoiner j = new StringJoiner("\n");
        String[] lines = comment.split("\n");
        for (int i = 0; i < lines.length - 2; ++i) {
            j.add(lines[i]);
        }
        String lastLine = lines[lines.length - 1];
        if (ParserUtil.containsQuotationPattern(lastLine)) {
            if (lines.length > 1) {
                j.add(lines[lines.length - 2]);
            }
            return j.toString().trim();
        }
        if (lines.length > 1 && ParserUtil.containsQuotationPattern(lastLines = lines[lines.length - 2] + lastLine)) {
            return j.toString().trim();
        }
        if (lines.length > 1) {
            j.add(lines[lines.length - 2]);
        }
        j.add(lines[lines.length - 1]);
        return j.toString().trim();
    }

    public static boolean isCommentUrl(String str, String changeUrl, Comment comment) {
        int lineNbr = comment.range == null ? comment.lineNbr : comment.range.startLine;
        return str.equals(ParserUtil.filePath(changeUrl, comment) + "@" + lineNbr) || str.equals(ParserUtil.filePath(changeUrl, comment) + "@a" + lineNbr);
    }

    public static String filePath(String changeUrl, Comment comment) {
        return changeUrl + "/" + comment.key.patchSetId + "/" + comment.key.filename;
    }

    private static boolean containsQuotationPattern(String s) {
        int numConsecutiveDigits = 0;
        int maxConsecutiveDigits = 0;
        int numDigitGroups = 0;
        for (char c : s.toCharArray()) {
            if (c >= '0' && c <= '9') {
                ++numConsecutiveDigits;
                continue;
            }
            if (numConsecutiveDigits <= 0) continue;
            maxConsecutiveDigits = Integer.max(maxConsecutiveDigits, numConsecutiveDigits);
            numConsecutiveDigits = 0;
            ++numDigitGroups;
        }
        if (numDigitGroups < 4 || maxConsecutiveDigits > 4) {
            return false;
        }
        return SIMPLE_EMAIL_PATTERN.matcher(s).find();
    }
}

