/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb;

import com.google.auto.value.AutoValue;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Sets;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Comment;
import com.google.gerrit.reviewdb.client.PatchLineComment;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.client.RefNames;
import com.google.gerrit.reviewdb.client.RevId;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.config.AnonymousCowardName;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.notedb.AbstractChangeUpdate;
import com.google.gerrit.server.notedb.AutoValue_ChangeDraftUpdate_Key;
import com.google.gerrit.server.notedb.ChangeNoteUtil;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.notedb.ChangeRevisionNote;
import com.google.gerrit.server.notedb.DraftCommentNotes;
import com.google.gerrit.server.notedb.NotesMigration;
import com.google.gerrit.server.notedb.RevisionNoteBuilder;
import com.google.gerrit.server.notedb.RevisionNoteMap;
import com.google.gwtorm.server.OrmException;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.notes.NoteMap;
import org.eclipse.jgit.revwalk.RevWalk;

public class ChangeDraftUpdate
extends AbstractChangeUpdate {
    private final AllUsersName draftsProject;
    private List<Comment> put = new ArrayList<Comment>();
    private Set<Key> delete = new HashSet<Key>();

    private static Key key(Comment c) {
        return new AutoValue_ChangeDraftUpdate_Key(c.revId, c.key);
    }

    @AssistedInject
    private ChangeDraftUpdate(@GerritServerConfig Config cfg, @GerritPersonIdent PersonIdent serverIdent, @AnonymousCowardName String anonymousCowardName, NotesMigration migration, AllUsersName allUsers, ChangeNoteUtil noteUtil, @Assisted ChangeNotes notes, @Assisted(value="effective") Account.Id accountId, @Assisted(value="real") Account.Id realAccountId, @Assisted PersonIdent authorIdent, @Assisted Date when) {
        super(cfg, migration, noteUtil, serverIdent, anonymousCowardName, notes, null, accountId, realAccountId, authorIdent, when);
        this.draftsProject = allUsers;
    }

    @AssistedInject
    private ChangeDraftUpdate(@GerritServerConfig Config cfg, @GerritPersonIdent PersonIdent serverIdent, @AnonymousCowardName String anonymousCowardName, NotesMigration migration, AllUsersName allUsers, ChangeNoteUtil noteUtil, @Assisted Change change, @Assisted(value="effective") Account.Id accountId, @Assisted(value="real") Account.Id realAccountId, @Assisted PersonIdent authorIdent, @Assisted Date when) {
        super(cfg, migration, noteUtil, serverIdent, anonymousCowardName, null, change, accountId, realAccountId, authorIdent, when);
        this.draftsProject = allUsers;
    }

    public void putComment(Comment c) {
        this.verifyComment(c);
        this.put.add(c);
    }

    public void deleteComment(Comment c) {
        this.verifyComment(c);
        this.delete.add(ChangeDraftUpdate.key(c));
    }

    public void deleteComment(String revId, Comment.Key key) {
        this.delete.add(new AutoValue_ChangeDraftUpdate_Key(revId, key));
    }

    private CommitBuilder storeCommentsInNotes(RevWalk rw, ObjectInserter ins, ObjectId curr, CommitBuilder cb) throws ConfigInvalidException, OrmException, IOException {
        RevisionNoteMap<ChangeRevisionNote> rnm = this.getRevisionNoteMap(rw, curr);
        HashSet<RevId> updatedRevs = Sets.newHashSetWithExpectedSize(rnm.revisionNotes.size());
        RevisionNoteBuilder.Cache cache = new RevisionNoteBuilder.Cache(rnm);
        for (Comment c : this.put) {
            if (this.delete.contains(ChangeDraftUpdate.key(c))) continue;
            cache.get(new RevId(c.revId)).putComment(c);
        }
        for (Key k : this.delete) {
            cache.get(new RevId(k.revId())).deleteComment(k.key());
        }
        Map<RevId, RevisionNoteBuilder> builders = cache.getBuilders();
        boolean touchedAnyRevs = false;
        boolean hasComments = false;
        for (Map.Entry<RevId, RevisionNoteBuilder> e : builders.entrySet()) {
            updatedRevs.add(e.getKey());
            ObjectId id = ObjectId.fromString(e.getKey().get());
            byte[] data = e.getValue().build(this.noteUtil, this.noteUtil.getWriteJson());
            if (!Arrays.equals(data, e.getValue().baseRaw)) {
                touchedAnyRevs = true;
            }
            if (data.length == 0) {
                rnm.noteMap.remove(id);
                continue;
            }
            hasComments = true;
            ObjectId dataBlob = ins.insert(3, data);
            rnm.noteMap.set(id, dataBlob);
        }
        if (!touchedAnyRevs) {
            return NO_OP_UPDATE;
        }
        boolean touchedAllRevs = updatedRevs.equals(rnm.revisionNotes.keySet());
        if (touchedAllRevs && !hasComments) {
            return null;
        }
        cb.setTreeId(rnm.noteMap.writeTree(ins));
        return cb;
    }

    private RevisionNoteMap<ChangeRevisionNote> getRevisionNoteMap(RevWalk rw, ObjectId curr) throws ConfigInvalidException, OrmException, IOException {
        DraftCommentNotes draftNotes;
        ChangeNotes changeNotes;
        if (this.migration.readChanges() && (changeNotes = this.getNotes()) != null && (draftNotes = ((ChangeNotes)changeNotes.load()).getDraftCommentNotes()) != null) {
            ObjectId idFromNotes = MoreObjects.firstNonNull(draftNotes.getRevision(), ObjectId.zeroId());
            RevisionNoteMap<ChangeRevisionNote> rnm = draftNotes.getRevisionNoteMap();
            if (idFromNotes.equals(curr) && rnm != null) {
                return rnm;
            }
        }
        NoteMap noteMap = !curr.equals(ObjectId.zeroId()) ? NoteMap.read(rw.getObjectReader(), rw.parseCommit(curr)) : NoteMap.newEmptyMap();
        return RevisionNoteMap.parse(this.noteUtil, this.getId(), rw.getObjectReader(), noteMap, PatchLineComment.Status.DRAFT);
    }

    @Override
    protected CommitBuilder applyImpl(RevWalk rw, ObjectInserter ins, ObjectId curr) throws OrmException, IOException {
        CommitBuilder cb = new CommitBuilder();
        cb.setMessage("Update draft comments");
        try {
            return this.storeCommentsInNotes(rw, ins, curr, cb);
        }
        catch (ConfigInvalidException e) {
            throw new OrmException(e);
        }
    }

    @Override
    protected Project.NameKey getProjectName() {
        return this.draftsProject;
    }

    @Override
    protected String getRefName() {
        return RefNames.refsDraftComments(this.getId(), this.accountId);
    }

    @Override
    public boolean isEmpty() {
        return this.delete.isEmpty() && this.put.isEmpty();
    }

    @AutoValue
    static abstract class Key {
        Key() {
        }

        abstract String revId();

        abstract Comment.Key key();
    }

    public static interface Factory {
        public ChangeDraftUpdate create(ChangeNotes var1, @Assisted(value="effective") Account.Id var2, @Assisted(value="real") Account.Id var3, PersonIdent var4, Date var5);

        public ChangeDraftUpdate create(Change var1, @Assisted(value="effective") Account.Id var2, @Assisted(value="real") Account.Id var3, PersonIdent var4, Date var5);
    }
}

