/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb.rebuild;

import com.google.common.base.MoreObjects;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Comment;
import com.google.gerrit.reviewdb.client.PatchLineComment;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.server.CommentsUtil;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.notedb.rebuild.Event;
import com.google.gerrit.server.patch.PatchListCache;
import com.google.gwtorm.server.OrmException;

class CommentEvent
extends Event {
    public final Comment c;
    private final Change change;
    private final PatchSet ps;
    private final PatchListCache cache;

    CommentEvent(Comment c, Change change, PatchSet ps, PatchListCache cache) {
        super(CommentsUtil.getCommentPsId(change.getId(), c), c.author.getId(), c.getRealAuthor().getId(), c.writtenOn, change.getCreatedOn(), c.tag);
        this.c = c;
        this.change = change;
        this.ps = ps;
        this.cache = cache;
    }

    @Override
    boolean uniquePerUpdate() {
        return false;
    }

    @Override
    protected boolean canHaveTag() {
        return true;
    }

    @Override
    void apply(ChangeUpdate update) throws OrmException {
        this.checkUpdate(update);
        if (this.c.revId == null) {
            CommentsUtil.setCommentRevId(this.c, this.cache, this.change, this.ps);
        }
        update.putComment(PatchLineComment.Status.PUBLISHED, this.c);
    }

    @Override
    protected void addToString(MoreObjects.ToStringHelper helper) {
        helper.add("message", this.c.message);
    }
}

