/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.patch;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

public class MergeListBuilder {
    public static List<RevCommit> build(RevWalk rw, RevCommit merge, int uninterestingParent) throws IOException {
        RevCommit c;
        rw.reset();
        rw.parseBody(merge);
        if (merge.getParentCount() < 2) {
            return ImmutableList.of();
        }
        for (int parent = 0; parent < merge.getParentCount(); ++parent) {
            RevCommit parentCommit = merge.getParent(parent);
            rw.parseBody(parentCommit);
            if (parent == uninterestingParent - 1) {
                rw.markUninteresting(parentCommit);
                continue;
            }
            rw.markStart(parentCommit);
        }
        ArrayList<RevCommit> result = new ArrayList<RevCommit>();
        while ((c = rw.next()) != null) {
            result.add(c);
        }
        return result;
    }
}

