/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Sets;
import com.google.gerrit.extensions.api.projects.BranchInfo;
import com.google.gerrit.extensions.common.ActionInfo;
import com.google.gerrit.extensions.common.WebLinkInfo;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.extensions.webui.UiAction;
import com.google.gerrit.server.WebLinks;
import com.google.gerrit.server.extensions.webui.UiActions;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.project.BranchResource;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gerrit.server.project.RefControl;
import com.google.gerrit.server.project.RefFilter;
import com.google.inject.Inject;
import com.google.inject.util.Providers;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.kohsuke.args4j.Option;

public class ListBranches
implements RestReadView<ProjectResource> {
    private final GitRepositoryManager repoManager;
    private final DynamicMap<RestView<BranchResource>> branchViews;
    private final WebLinks webLinks;
    private int limit;
    private int start;
    private String matchSubstring;
    private String matchRegex;

    @Option(name="--limit", aliases={"-n"}, metaVar="CNT", usage="maximum number of branches to list")
    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Option(name="--start", aliases={"-S"}, metaVar="CNT", usage="number of branches to skip")
    public void setStart(int start) {
        this.start = start;
    }

    @Option(name="--match", aliases={"-m"}, metaVar="MATCH", usage="match branches substring")
    public void setMatchSubstring(String matchSubstring) {
        this.matchSubstring = matchSubstring;
    }

    @Option(name="--regex", aliases={"-r"}, metaVar="REGEX", usage="match branches regex")
    public void setMatchRegex(String matchRegex) {
        this.matchRegex = matchRegex;
    }

    @Inject
    public ListBranches(GitRepositoryManager repoManager, DynamicMap<RestView<BranchResource>> branchViews, WebLinks webLinks) {
        this.repoManager = repoManager;
        this.branchViews = branchViews;
        this.webLinks = webLinks;
    }

    public List<BranchInfo> apply(ProjectResource rsrc) throws ResourceNotFoundException, IOException, BadRequestException {
        return new RefFilter("refs/heads/").subString(this.matchSubstring).regex(this.matchRegex).start(this.start).limit(this.limit).filter(this.allBranches(rsrc));
    }

    private List<BranchInfo> allBranches(ProjectResource rsrc) throws IOException, ResourceNotFoundException {
        ArrayList<Ref> refs;
        try {
            Repository db = this.repoManager.openRepository(rsrc.getNameKey());
            Object object = null;
            try {
                Collection<Ref> heads = db.getRefDatabase().getRefs("refs/heads/").values();
                refs = new ArrayList<Ref>(heads.size() + 3);
                refs.addAll(heads);
                refs.addAll(db.getRefDatabase().exactRef("HEAD", "refs/meta/config", "refs/users/default").values());
            }
            catch (Throwable heads) {
                object = heads;
                throw heads;
            }
            finally {
                if (db != null) {
                    if (object != null) {
                        try {
                            db.close();
                        }
                        catch (Throwable heads) {
                            ((Throwable)object).addSuppressed(heads);
                        }
                    } else {
                        db.close();
                    }
                }
            }
        }
        catch (RepositoryNotFoundException noGitRepository) {
            throw new ResourceNotFoundException();
        }
        HashSet<String> targets = Sets.newHashSetWithExpectedSize(1);
        for (Ref ref : refs) {
            if (!ref.isSymbolic()) continue;
            targets.add(ref.getTarget().getName());
        }
        ArrayList<BranchInfo> branches = new ArrayList<BranchInfo>(refs.size());
        for (Ref ref : refs) {
            if (ref.isSymbolic()) {
                String target = ref.getTarget().getName();
                RefControl targetRefControl = rsrc.getControl().controlForRef(target);
                if (!targetRefControl.isVisible()) continue;
                if (target.startsWith("refs/heads/")) {
                    target = target.substring("refs/heads/".length());
                }
                BranchInfo b = new BranchInfo();
                b.ref = ref.getName();
                b.revision = target;
                branches.add(b);
                if ("HEAD".equals(ref.getName())) continue;
                b.canDelete = targetRefControl.canDelete() ? Boolean.valueOf(true) : null;
                continue;
            }
            RefControl refControl = rsrc.getControl().controlForRef(ref.getName());
            if (!refControl.isVisible()) continue;
            branches.add(this.createBranchInfo(ref, refControl, targets));
        }
        Collections.sort(branches, new BranchComparator());
        return branches;
    }

    private BranchInfo createBranchInfo(Ref ref, RefControl refControl, Set<String> targets) {
        BranchInfo info = new BranchInfo();
        info.ref = ref.getName();
        info.revision = ref.getObjectId() != null ? ref.getObjectId().name() : null;
        info.canDelete = !targets.contains(ref.getName()) && refControl.canDelete() ? Boolean.valueOf(true) : null;
        for (UiAction.Description d : UiActions.from(this.branchViews, new BranchResource(refControl.getProjectControl(), info), Providers.of(refControl.getUser()))) {
            if (info.actions == null) {
                info.actions = new TreeMap<String, ActionInfo>();
            }
            info.actions.put(d.getId(), new ActionInfo(d));
        }
        List<WebLinkInfo> links = this.webLinks.getBranchLinks(refControl.getProjectControl().getProject().getName(), ref.getName());
        info.webLinks = links.isEmpty() ? null : links;
        return info;
    }

    private static class BranchComparator
    implements Comparator<BranchInfo> {
        private BranchComparator() {
        }

        @Override
        public int compare(BranchInfo a, BranchInfo b) {
            return ComparisonChain.start().compareTrueFirst(BranchComparator.isHead(a), BranchComparator.isHead(b)).compareTrueFirst(BranchComparator.isConfig(a), BranchComparator.isConfig(b)).compare((Comparable<?>)((Object)a.ref), (Comparable<?>)((Object)b.ref)).result();
        }

        private static boolean isHead(BranchInfo i) {
            return "HEAD".equals(i.ref);
        }

        private static boolean isConfig(BranchInfo i) {
            return "refs/meta/config".equals(i.ref);
        }
    }
}

