/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.server.config.TrackingFooters;
import com.google.gerrit.server.index.change.ChangeField;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeIndexPredicate;
import com.google.gwtorm.server.OrmException;
import java.io.IOException;
import java.util.List;
import org.eclipse.jgit.revwalk.FooterLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TrackingIdPredicate
extends ChangeIndexPredicate {
    private static final Logger log = LoggerFactory.getLogger(TrackingIdPredicate.class);
    private final TrackingFooters trackingFooters;

    TrackingIdPredicate(TrackingFooters trackingFooters, String trackingId) {
        super(ChangeField.TR, trackingId);
        this.trackingFooters = trackingFooters;
    }

    @Override
    public boolean match(ChangeData object) throws OrmException {
        Change c = object.change();
        if (c != null) {
            try {
                List<FooterLine> footers = object.commitFooters();
                return footers != null && this.trackingFooters.extract(object.commitFooters()).values().contains(this.getValue());
            }
            catch (IOException e) {
                log.warn("Cannot extract footers from " + c.getChangeId(), e);
            }
        }
        return false;
    }

    @Override
    public int getCost() {
        return 1;
    }
}

