/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.group;

import com.google.common.base.Preconditions;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.GroupControl;
import com.google.gerrit.server.index.IndexConfig;
import com.google.gerrit.server.index.IndexPredicate;
import com.google.gerrit.server.index.group.GroupIndexCollection;
import com.google.gerrit.server.index.group.GroupIndexRewriter;
import com.google.gerrit.server.index.group.GroupSchemaDefinitions;
import com.google.gerrit.server.query.AndSource;
import com.google.gerrit.server.query.Predicate;
import com.google.gerrit.server.query.QueryProcessor;
import com.google.gerrit.server.query.group.GroupIsVisibleToPredicate;
import com.google.inject.Inject;
import com.google.inject.Provider;

public class GroupQueryProcessor
extends QueryProcessor<AccountGroup> {
    private final GroupControl.GenericFactory groupControlFactory;

    @Inject
    protected GroupQueryProcessor(Provider<CurrentUser> userProvider, QueryProcessor.Metrics metrics, IndexConfig indexConfig, GroupIndexCollection indexes, GroupIndexRewriter rewriter, GroupControl.GenericFactory groupControlFactory) {
        super(userProvider, metrics, GroupSchemaDefinitions.INSTANCE, indexConfig, indexes, rewriter, "limit");
        this.groupControlFactory = groupControlFactory;
    }

    @Override
    protected Predicate<AccountGroup> enforceVisibility(Predicate<AccountGroup> pred) {
        return new AndSource<AccountGroup>(pred, new GroupIsVisibleToPredicate(this.groupControlFactory, (CurrentUser)this.userProvider.get()), this.start);
    }

    static {
        Preconditions.checkState(!GroupIsVisibleToPredicate.class.isAssignableFrom(IndexPredicate.class), "GroupQueryProcessor assumes visibleto is not used by the index rewriter.");
    }
}

