/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.schema.BaseDataSourceType;
import com.google.inject.Inject;
import org.eclipse.jgit.lib.Config;

class Derby
extends BaseDataSourceType {
    protected final Config cfg;
    private final SitePaths site;

    @Inject
    Derby(@GerritServerConfig Config cfg, SitePaths site) {
        super("org.apache.derby.jdbc.EmbeddedDriver");
        this.cfg = cfg;
        this.site = site;
    }

    @Override
    public String getUrl() {
        String database = this.cfg.getString("database", null, "database");
        if (database == null || database.isEmpty()) {
            database = "db/ReviewDB";
        }
        return "jdbc:derby:" + this.site.resolve(database).toString() + ";create=true";
    }

    @Override
    public String getValidationQuery() {
        return "values 1";
    }
}

