/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.gerrit.reviewdb.server.DisallowReadFromChangesReviewDbWrapper;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.notedb.NotesMigration;
import com.google.gerrit.server.schema.NoChangesReviewDbWrapper;
import com.google.gerrit.server.schema.ReviewDbFactory;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.Inject;
import com.google.inject.Singleton;

@Singleton
public class NotesMigrationSchemaFactory
implements SchemaFactory<ReviewDb> {
    private final SchemaFactory<ReviewDb> delegate;
    private final NotesMigration migration;

    @Inject
    NotesMigrationSchemaFactory(@ReviewDbFactory SchemaFactory<ReviewDb> delegate, NotesMigration migration) {
        this.delegate = delegate;
        this.migration = migration;
    }

    @Override
    public ReviewDb open() throws OrmException {
        ReviewDb db = this.delegate.open();
        if (!this.migration.readChanges()) {
            return db;
        }
        if (this.migration.disableChangeReviewDb()) {
            db = new NoChangesReviewDbWrapper(db);
        }
        return new DisallowReadFromChangesReviewDbWrapper(db);
    }
}

