/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gerrit.server.schema.Schema_101;
import com.google.gerrit.server.schema.UpdateUI;
import com.google.gwtorm.jdbc.JdbcExecutor;
import com.google.gwtorm.jdbc.JdbcSchema;
import com.google.gwtorm.schema.sql.DialectPostgreSQL;
import com.google.gwtorm.schema.sql.SqlDialect;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.sql.SQLException;
import java.util.Set;
import java.util.regex.Pattern;

public class Schema_102
extends SchemaVersion {
    @Inject
    Schema_102(Provider<Schema_101> prior) {
        super(prior);
    }

    @Override
    protected void migrateData(ReviewDb db, UpdateUI ui) throws OrmException, SQLException {
        JdbcSchema schema = (JdbcSchema)((Object)db);
        SqlDialect dialect = schema.getDialect();
        try (JdbcExecutor e = Schema_102.newExecutor(db);){
            Pattern pattern = Pattern.compile("^changes_(allOpen|allClosed|byBranchClosed)$", 2);
            String table = "changes";
            Set<String> listIndexes = dialect.listIndexes(schema.getConnection(), table);
            for (String index : listIndexes) {
                if (!pattern.matcher(index).matches()) continue;
                dialect.dropIndex(e, table, index);
            }
            dialect.dropIndex(e, table, "changes_byProjectOpen");
            if (dialect instanceof DialectPostgreSQL) {
                e.execute("CREATE INDEX changes_byProjectOpen ON " + table + " (dest_project_name, last_updated_on) WHERE open = 'Y'");
            } else {
                e.execute("CREATE INDEX changes_byProjectOpen ON " + table + " (open, dest_project_name, last_updated_on)");
            }
        }
    }
}

