/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.gerrit.reviewdb.client.AccountExternalId;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.account.HashedPassword;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gerrit.server.schema.Schema_141;
import com.google.gerrit.server.schema.UpdateUI;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.sql.SQLException;
import java.util.List;

public class Schema_142
extends SchemaVersion {
    @Inject
    Schema_142(Provider<Schema_141> prior) {
        super(prior);
    }

    @Override
    protected void migrateData(ReviewDb db, UpdateUI ui) throws OrmException, SQLException {
        List<AccountExternalId> newIds = db.accountExternalIds().all().toList();
        for (AccountExternalId id : newIds) {
            String password;
            if (!id.isScheme("username:") || (password = id.getPassword()) == null) continue;
            HashedPassword hashed = HashedPassword.fromPassword(password);
            id.setPassword(hashed.encode());
        }
        db.accountExternalIds().upsert(newIds);
    }
}

