/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd;

import com.google.gerrit.sshd.AutoAnnotation_Commands_named;
import com.google.gerrit.sshd.CommandName;
import com.google.inject.Key;
import java.lang.annotation.Annotation;
import org.apache.sshd.server.Command;

public class Commands {
    public static final String ROOT = "";
    public static final CommandName CMD_ROOT = Commands.named("");

    public static Key<Command> key(String name) {
        return Commands.key(Commands.named(name));
    }

    public static Key<Command> key(CommandName name) {
        return Key.get(Command.class, (Annotation)name);
    }

    public static Key<Command> key(CommandName parent, String name) {
        return Key.get(Command.class, (Annotation)Commands.named(parent, name));
    }

    public static Key<Command> key(CommandName parent, String name, String descr) {
        return Key.get(Command.class, (Annotation)Commands.named(parent, name, descr));
    }

    public static CommandName named(String value) {
        return new AutoAnnotation_Commands_named(value);
    }

    public static CommandName named(CommandName parent, String name) {
        return new NestedCommandNameImpl(parent, name);
    }

    public static CommandName named(CommandName parent, String name, String descr) {
        return new NestedCommandNameImpl(parent, name, descr);
    }

    public static String nameOf(CommandName name) {
        if (name instanceof NestedCommandNameImpl) {
            return Commands.nameOf(((NestedCommandNameImpl)name).parent) + " " + name.value();
        }
        return name.value();
    }

    public static boolean isChild(CommandName parent, CommandName name) {
        if (name instanceof NestedCommandNameImpl) {
            return parent.equals(((NestedCommandNameImpl)name).parent);
        }
        return parent == CMD_ROOT;
    }

    static CommandName parentOf(CommandName name) {
        if (name instanceof NestedCommandNameImpl) {
            return ((NestedCommandNameImpl)name).parent;
        }
        return null;
    }

    private Commands() {
    }

    static final class NestedCommandNameImpl
    implements CommandName {
        private final CommandName parent;
        private final String name;
        private final String descr;

        NestedCommandNameImpl(CommandName parent, String name) {
            this.parent = parent;
            this.name = name;
            this.descr = Commands.ROOT;
        }

        NestedCommandNameImpl(CommandName parent, String name, String descr) {
            this.parent = parent;
            this.name = name;
            this.descr = descr;
        }

        @Override
        public String value() {
            return this.name;
        }

        public String descr() {
            return this.descr;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return CommandName.class;
        }

        @Override
        public int hashCode() {
            return this.parent.hashCode() * 31 + this.value().hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof NestedCommandNameImpl && this.parent.equals(((NestedCommandNameImpl)obj).parent) && this.value().equals(((NestedCommandNameImpl)obj).value());
        }

        @Override
        public String toString() {
            return "CommandName[" + Commands.nameOf(this) + "]";
        }
    }
}

