/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd;

import com.google.common.collect.Maps;
import com.google.gerrit.extensions.registration.RegistrationHandle;
import com.google.gerrit.sshd.CommandName;
import com.google.gerrit.sshd.CommandProvider;
import com.google.gerrit.sshd.Commands;
import com.google.gerrit.sshd.DispatchCommand;
import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.apache.sshd.server.Command;

public class DispatchCommandProvider
implements Provider<DispatchCommand> {
    @Inject
    private Injector injector;
    @Inject
    private DispatchCommand.Factory factory;
    private final CommandName parent;
    private volatile ConcurrentMap<String, CommandProvider> map;
    private static final TypeLiteral<Command> type = new TypeLiteral<Command>(){};

    public DispatchCommandProvider(CommandName cn) {
        this.parent = cn;
    }

    @Override
    public DispatchCommand get() {
        return this.factory.create(this.getMap());
    }

    public RegistrationHandle register(final CommandName name, Provider<Command> cmd) {
        final ConcurrentMap<String, CommandProvider> m = this.getMap();
        final CommandProvider commandProvider = new CommandProvider(cmd, null);
        if (m.putIfAbsent(name.value(), commandProvider) != null) {
            throw new IllegalArgumentException(name.value() + " exists");
        }
        return new RegistrationHandle(){

            @Override
            public void remove() {
                m.remove(name.value(), commandProvider);
            }
        };
    }

    public RegistrationHandle replace(final CommandName name, Provider<Command> cmd) {
        final ConcurrentMap<String, CommandProvider> m = this.getMap();
        final CommandProvider commandProvider = new CommandProvider(cmd, null);
        m.put(name.value(), commandProvider);
        return new RegistrationHandle(){

            @Override
            public void remove() {
                m.remove(name.value(), commandProvider);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConcurrentMap<String, CommandProvider> getMap() {
        if (this.map == null) {
            DispatchCommandProvider dispatchCommandProvider = this;
            synchronized (dispatchCommandProvider) {
                if (this.map == null) {
                    this.map = this.createMap();
                }
            }
        }
        return this.map;
    }

    private ConcurrentMap<String, CommandProvider> createMap() {
        ConcurrentMap<String, CommandProvider> m = Maps.newConcurrentMap();
        for (Binding<Command> b : this.allCommands()) {
            CommandName n;
            Annotation annotation = b.getKey().getAnnotation();
            if (!(annotation instanceof CommandName) || Commands.CMD_ROOT.equals(n = (CommandName)annotation) || !Commands.isChild(this.parent, n)) continue;
            String descr = null;
            if (annotation instanceof Commands.NestedCommandNameImpl) {
                Commands.NestedCommandNameImpl impl = (Commands.NestedCommandNameImpl)annotation;
                descr = impl.descr();
            }
            m.put(n.value(), new CommandProvider(b.getProvider(), descr));
        }
        return m;
    }

    private List<Binding<Command>> allCommands() {
        return this.injector.findBindingsByType(type);
    }
}

