/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.sshd.AdminHighPriorityCommand;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.SshCommand;
import com.google.gerrit.sshd.SshDaemon;
import com.google.gerrit.sshd.SshSession;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.session.helpers.AbstractSession;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AdminHighPriorityCommand
@RequiresCapability(value="administrateServer")
@CommandMetaData(name="close-connection", description="Close the specified SSH connection", runsAt=CommandMetaData.Mode.MASTER_OR_SLAVE)
final class CloseConnection
extends SshCommand {
    private static final Logger log = LoggerFactory.getLogger(CloseConnection.class);
    @Inject
    private SshDaemon sshDaemon;
    @Argument(index=0, multiValued=true, required=true, metaVar="SESSION_ID", usage="List of SSH session IDs to be closed")
    private final List<String> sessionIds = new ArrayList<String>();
    @Option(name="--wait", usage="wait for connection to close before exiting")
    private boolean wait;

    CloseConnection() {
    }

    @Override
    protected void run() throws BaseCommand.Failure {
        IoAcceptor acceptor = this.sshDaemon.getIoAcceptor();
        if (acceptor == null) {
            throw new BaseCommand.Failure(1, "fatal: sshd no longer running");
        }
        for (String sessionId : this.sessionIds) {
            boolean connectionFound = false;
            int id = (int)Long.parseLong(sessionId, 16);
            for (IoSession io : acceptor.getManagedSessions().values()) {
                AbstractSession serverSession = AbstractSession.getSession(io, true);
                SshSession sshSession = serverSession != null ? serverSession.getAttribute(SshSession.KEY) : null;
                if (sshSession == null || sshSession.getSessionId() != id) continue;
                connectionFound = true;
                this.stdout.println("closing connection " + sessionId + "...");
                CloseFuture future = io.close(true);
                if (!this.wait) break;
                try {
                    future.await();
                    this.stdout.println("closed connection " + sessionId);
                }
                catch (IOException e) {
                    log.warn("Wait for connection to close interrupted: " + e.getMessage());
                }
                break;
            }
            if (connectionFound) continue;
            this.stderr.print("close connection " + sessionId + ": no such connection\n");
        }
    }
}

