/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprparse;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Longs;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprparse.ExpressionParserConstants;
import com.google.template.soy.exprparse.ExpressionParserTokenManager;
import com.google.template.soy.exprparse.ParseErrors;
import com.google.template.soy.exprparse.ParseException;
import com.google.template.soy.exprparse.SimpleCharStream;
import com.google.template.soy.exprparse.SoyParsingContext;
import com.google.template.soy.exprparse.Token;
import com.google.template.soy.exprparse.Tokens;
import com.google.template.soy.exprtree.AbstractPrimitiveNode;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.exprtree.ProtoInitNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.internal.base.UnescapeUtils;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public final class ExpressionParser
implements ExpressionParserConstants {
    private static final SoyErrorKind DUPLICATE_PARAM_NAME = SoyErrorKind.of("Duplicate param name ''{0}''");
    private static final SoyErrorKind INTEGER_OUT_OF_RANGE = SoyErrorKind.of("Soy integers are constrained to the range of JavaScript integers: https://www.ecma-international.org/ecma-262/5.1/#sec-8.5");
    private static final SoyErrorKind INVALID_FUNCTION_NAME = SoyErrorKind.of("Invalid function name ''{0}''");
    private static final SoyErrorKind INVALID_PARAM_NAME = SoyErrorKind.of("Invalid param name ''{0}''");
    private static final SoyErrorKind INVALID_VAR_NAME_IJ = SoyErrorKind.of("Invalid var name ''ij'' (''ij'' is for injected data ref).");
    private static final SoyErrorKind SINGLE_IDENTIFIER_KEY_IN_MAP_LITERAL = SoyErrorKind.of("Disallowed single-identifier key \"{0}\" in map literal (please surround with single quotes for string or parentheses for global).");
    private static final SoyErrorKind UNEXPECTED_IJ_DATA_REFERENCE = SoyErrorKind.of("Expected a variable name, but found an ''ij'' data reference.");
    private String input;
    private SourceLocation parentSourceLocation;
    private ErrorReporter errorReporter;
    public ExpressionParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[34];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[2];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public ExpressionParser(String input, SourceLocation parentSourceLocation, SoyParsingContext context) {
        this(new StringReader(input));
        this.input = input;
        this.parentSourceLocation = parentSourceLocation;
        this.errorReporter = context.errorReporter();
    }

    public List<ExprNode> parseExpressionList() {
        try {
            return this.ExprListInput();
        }
        catch (ParseException e) {
            ParseErrors.reportExprParseException(this.errorReporter, this.parentSourceLocation, e);
            return ImmutableList.of();
        }
    }

    public ExprNode parseExpression() {
        try {
            return this.ExprInput();
        }
        catch (ParseException e) {
            ParseErrors.reportExprParseException(this.errorReporter, this.parentSourceLocation, e);
            return VarRefNode.ERROR;
        }
    }

    public VarRefNode parseVariable() {
        try {
            VarRefNode node = this.VarRef();
            if (node.isDollarSignIjParameter()) {
                this.errorReporter.report(node.getSourceLocation(), UNEXPECTED_IJ_DATA_REFERENCE, new Object[0]);
                return VarRefNode.ERROR;
            }
            return node;
        }
        catch (ParseException e) {
            ParseErrors.reportExprParseException(this.errorReporter, "Expected a variable name ", this.parentSourceLocation, e);
            return VarRefNode.ERROR;
        }
    }

    private static final ExprNode.OperatorNode createOperatorNode(String op, int prec, ExprNode ... children) {
        Operator operator = Operator.of(op, children.length);
        if (operator.getPrecedence() != prec) {
            throw new IllegalArgumentException("invalid precedence " + prec + " for operator " + op);
        }
        return operator.createNode(children);
    }

    private SourceLocation createSrcLoc(Token token) {
        return Tokens.createSrcLoc(this.parentSourceLocation, token);
    }

    private SourceLocation createSrcLoc(Token token1, Token token2) {
        return this.createSrcLoc(token1).extend(this.createSrcLoc(token2));
    }

    private final ExprNode.PrimitiveNode Primitive() throws ParseException {
        AbstractPrimitiveNode primitive;
        switch (this.jj_nt.kind) {
            case 1: {
                Token tok = this.jj_consume_token(1);
                primitive = new NullNode(this.createSrcLoc(tok));
                break;
            }
            case 2: {
                Token tok = this.jj_consume_token(2);
                primitive = new BooleanNode(true, this.createSrcLoc(tok));
                break;
            }
            case 3: {
                Token tok = this.jj_consume_token(3);
                primitive = new BooleanNode(false, this.createSrcLoc(tok));
                break;
            }
            case 4: {
                Token tok = this.jj_consume_token(4);
                SourceLocation loc = this.createSrcLoc(tok);
                Long parsed = Longs.tryParse(tok.image, 10);
                if (parsed == null || !IntegerNode.isInRange(parsed)) {
                    this.errorReporter.report(loc, INTEGER_OUT_OF_RANGE, new Object[0]);
                    parsed = 0L;
                }
                primitive = new IntegerNode(parsed, loc);
                break;
            }
            case 5: {
                Token tok = this.jj_consume_token(5);
                SourceLocation loc = this.createSrcLoc(tok);
                Long parsed = Longs.tryParse(tok.image.substring(2), 16);
                if (parsed == null || !IntegerNode.isInRange(parsed)) {
                    this.errorReporter.report(loc, INTEGER_OUT_OF_RANGE, new Object[0]);
                    parsed = 0L;
                }
                primitive = new IntegerNode(parsed, loc);
                break;
            }
            case 6: {
                Token tok = this.jj_consume_token(6);
                primitive = new FloatNode(Double.parseDouble(tok.image), this.createSrcLoc(tok));
                break;
            }
            case 7: {
                Token tok = this.jj_consume_token(7);
                String strNoQuotes = tok.image.substring(1, tok.image.length() - 1);
                primitive = new StringNode(UnescapeUtils.unescapeJs(strNoQuotes), this.createSrcLoc(tok));
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return primitive;
        }
        throw new Error("Missing return statement in function");
    }

    private final List<ExprNode> ExprListInput() throws ParseException {
        List<ExprNode> exprList = this.ExprList();
        this.jj_consume_token(0);
        if ("" != null) {
            return exprList;
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode ExprInput() throws ParseException {
        ExprNode expr = this.Expr();
        this.jj_consume_token(0);
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    private final List<ExprNode> ExprList() throws ParseException {
        ArrayList<ExprNode> exprList = new ArrayList<ExprNode>();
        ExprNode expr = this.Expr();
        exprList.add(expr);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 32: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(32);
            expr = this.Expr();
            exprList.add(expr);
        }
        if ("" != null) {
            return exprList;
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode Expr() throws ParseException {
        ExprNode expr = this.PrecExpr1();
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode PrecExpr1() throws ParseException {
        ExprNode expr = this.PrecExpr2();
        block0 : switch (this.jj_nt.kind) {
            case 10: 
            case 12: {
                switch (this.jj_nt.kind) {
                    case 12: {
                        this.jj_consume_token(12);
                        ExprNode expr1 = this.PrecExpr1();
                        expr = Operator.NULL_COALESCING.createNode(expr, expr1);
                        break block0;
                    }
                    case 10: {
                        this.jj_consume_token(10);
                        ExprNode expr1 = this.PrecExpr1();
                        this.jj_consume_token(11);
                        ExprNode expr2 = this.PrecExpr1();
                        expr = Operator.CONDITIONAL.createNode(expr, expr1, expr2);
                        break block0;
                    }
                }
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode PrecExpr2() throws ParseException {
        ExprNode expr = this.PrecExpr3();
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 13: {
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    break block3;
                }
            }
            Token op = this.jj_consume_token(13);
            ExprNode rightHand = this.PrecExpr3();
            expr = ExpressionParser.createOperatorNode(op.image, 2, expr, rightHand);
        }
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode PrecExpr3() throws ParseException {
        ExprNode expr = this.PrecExpr4();
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 14: {
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    break block3;
                }
            }
            Token op = this.jj_consume_token(14);
            ExprNode rightHand = this.PrecExpr4();
            expr = ExpressionParser.createOperatorNode(op.image, 3, expr, rightHand);
        }
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode PrecExpr4() throws ParseException {
        ExprNode expr = this.PrecExpr5();
        block7: while (true) {
            Token op;
            switch (this.jj_nt.kind) {
                case 15: 
                case 16: {
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_nt.kind) {
                case 15: {
                    op = this.jj_consume_token(15);
                    break;
                }
                case 16: {
                    op = this.jj_consume_token(16);
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            ExprNode rightHand = this.PrecExpr5();
            expr = ExpressionParser.createOperatorNode(op.image, 4, expr, rightHand);
        }
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode PrecExpr5() throws ParseException {
        ExprNode expr = this.PrecExpr6();
        block9: while (true) {
            Token op;
            switch (this.jj_nt.kind) {
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                    break block9;
                }
            }
            switch (this.jj_nt.kind) {
                case 17: {
                    op = this.jj_consume_token(17);
                    break;
                }
                case 18: {
                    op = this.jj_consume_token(18);
                    break;
                }
                case 19: {
                    op = this.jj_consume_token(19);
                    break;
                }
                case 20: {
                    op = this.jj_consume_token(20);
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            ExprNode rightHand = this.PrecExpr6();
            expr = ExpressionParser.createOperatorNode(op.image, 5, expr, rightHand);
        }
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode PrecExpr6() throws ParseException {
        ExprNode expr = this.PrecExpr7();
        block7: while (true) {
            Token op;
            switch (this.jj_nt.kind) {
                case 21: 
                case 22: {
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_nt.kind) {
                case 21: {
                    op = this.jj_consume_token(21);
                    break;
                }
                case 22: {
                    op = this.jj_consume_token(22);
                    break;
                }
                default: {
                    this.jj_la1[11] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            ExprNode rightHand = this.PrecExpr7();
            expr = ExpressionParser.createOperatorNode(op.image, 6, expr, rightHand);
        }
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode PrecExpr7() throws ParseException {
        ExprNode expr = this.PrecExpr8();
        block8: while (true) {
            Token op;
            switch (this.jj_nt.kind) {
                case 23: 
                case 24: 
                case 25: {
                    break;
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                    break block8;
                }
            }
            switch (this.jj_nt.kind) {
                case 23: {
                    op = this.jj_consume_token(23);
                    break;
                }
                case 24: {
                    op = this.jj_consume_token(24);
                    break;
                }
                case 25: {
                    op = this.jj_consume_token(25);
                    break;
                }
                default: {
                    this.jj_la1[13] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            ExprNode rightHand = this.PrecExpr8();
            expr = ExpressionParser.createOperatorNode(op.image, 7, expr, rightHand);
        }
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode PrecExpr8() throws ParseException {
        ExprNode expr;
        switch (this.jj_nt.kind) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 29: 
            case 33: 
            case 35: 
            case 36: 
            case 37: {
                expr = this.PrecExpr9();
                break;
            }
            case 22: 
            case 26: {
                Token unaryOp;
                switch (this.jj_nt.kind) {
                    case 26: {
                        unaryOp = this.jj_consume_token(26);
                        break;
                    }
                    case 22: {
                        unaryOp = this.jj_consume_token(22);
                        break;
                    }
                    default: {
                        this.jj_la1[14] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                expr = this.PrecExpr8();
                expr = ExpressionParser.createOperatorNode(unaryOp.image, 8, expr);
                break;
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode PrecExpr9() throws ParseException {
        ExprNode expr;
        block17: {
            expr = this.Primary();
            block15: while (true) {
                switch (this.jj_nt.kind) {
                    case 27: 
                    case 28: 
                    case 29: 
                    case 31: {
                        break;
                    }
                    default: {
                        this.jj_la1[16] = this.jj_gen;
                        break block17;
                    }
                }
                switch (this.jj_nt.kind) {
                    case 27: 
                    case 28: {
                        Token op;
                        switch (this.jj_nt.kind) {
                            case 27: {
                                op = this.jj_consume_token(27);
                                break;
                            }
                            case 28: {
                                op = this.jj_consume_token(28);
                                break;
                            }
                            default: {
                                this.jj_la1[17] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        Token ident = this.jj_consume_token(35);
                        expr = new FieldAccessNode(expr, ident.image, this.createSrcLoc(op, ident), op.kind == 28);
                        continue block15;
                    }
                    case 29: 
                    case 31: {
                        Token open;
                        switch (this.jj_nt.kind) {
                            case 29: {
                                open = this.jj_consume_token(29);
                                break;
                            }
                            case 31: {
                                open = this.jj_consume_token(31);
                                break;
                            }
                            default: {
                                this.jj_la1[18] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        ExprNode keyExpr = this.Expr();
                        Token close = this.jj_consume_token(30);
                        expr = new ItemAccessNode(expr, keyExpr, this.createSrcLoc(open, close), open.kind == 31);
                        continue block15;
                    }
                }
                break;
            }
            this.jj_la1[19] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode Primary() throws ParseException {
        ExprNode primary;
        switch (this.jj_nt.kind) {
            case 33: {
                this.jj_consume_token(33);
                primary = this.Expr();
                this.jj_consume_token(34);
                break;
            }
            case 36: 
            case 37: {
                primary = this.VarRef();
                break;
            }
            case 35: {
                primary = this.GlobalOrFunction();
                break;
            }
            case 29: {
                primary = this.CollectionLiteral();
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                primary = this.Primitive();
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return primary;
        }
        throw new Error("Missing return statement in function");
    }

    private final VarRefNode VarRef() throws ParseException {
        switch (this.jj_nt.kind) {
            case 36: {
                Token ij = this.jj_consume_token(36);
                switch (this.jj_nt.kind) {
                    case 27: {
                        this.jj_consume_token(27);
                        Token ident = this.jj_consume_token(35);
                        if ("" == null) break;
                        return new VarRefNode(ident.image, this.createSrcLoc(ij, ident), true, null);
                    }
                    default: {
                        this.jj_la1[21] = this.jj_gen;
                    }
                }
                SourceLocation loc = this.createSrcLoc(ij);
                this.errorReporter.report(loc, INVALID_VAR_NAME_IJ, new Object[0]);
                if ("" == null) break;
                return new VarRefNode("ij", loc, false, null);
            }
            case 37: {
                Token ident = this.jj_consume_token(37);
                if ("" == null) break;
                return new VarRefNode(ident.image.substring(1), this.createSrcLoc(ident), false, null);
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode GlobalOrFunction() throws ParseException {
        Token openParen = null;
        Token closeParen = null;
        ArrayList<ExprNode> params = new ArrayList<ExprNode>();
        Identifier ident = this.Identifier();
        switch (this.jj_nt.kind) {
            case 33: {
                openParen = this.jj_consume_token(33);
                block3 : switch (this.jj_nt.kind) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 22: 
                    case 26: 
                    case 29: 
                    case 33: 
                    case 35: 
                    case 36: 
                    case 37: {
                        ExprNode first = this.Expr();
                        switch (this.jj_nt.kind) {
                            case 11: {
                                this.jj_consume_token(11);
                                ExprNode expr = this.Expr();
                                if (!(first instanceof GlobalNode) || !BaseUtils.isIdentifier(((GlobalNode)first).getName())) {
                                    this.errorReporter.report(first.getSourceLocation(), INVALID_PARAM_NAME, first.toSourceString());
                                    first = GlobalNode.ERROR;
                                }
                                LinkedHashSet<String> paramNames = new LinkedHashSet<String>();
                                paramNames.add(((GlobalNode)first).getName());
                                params.add(expr);
                                block16: while (true) {
                                    switch (this.jj_nt.kind) {
                                        case 32: {
                                            break;
                                        }
                                        default: {
                                            this.jj_la1[23] = this.jj_gen;
                                            break block16;
                                        }
                                    }
                                    this.jj_consume_token(32);
                                    Token paramName = this.jj_consume_token(35);
                                    if (!paramNames.add(paramName.image)) {
                                        this.errorReporter.report(this.createSrcLoc(paramName), DUPLICATE_PARAM_NAME, paramName.image);
                                    }
                                    this.jj_consume_token(11);
                                    expr = this.Expr();
                                    params.add(expr);
                                }
                                closeParen = this.jj_consume_token(34);
                                ProtoInitNode pNode = new ProtoInitNode(ident.identifier(), paramNames, ident.location().extend(this.createSrcLoc(closeParen)));
                                pNode.addChildren((List<? extends ExprNode>)params);
                                if ("" == null) break block3;
                                return pNode;
                            }
                            case 32: 
                            case 34: {
                                params.add(first);
                                block17: while (true) {
                                    switch (this.jj_nt.kind) {
                                        case 32: {
                                            break;
                                        }
                                        default: {
                                            this.jj_la1[24] = this.jj_gen;
                                            break block17;
                                        }
                                    }
                                    this.jj_consume_token(32);
                                    ExprNode expr = this.Expr();
                                    params.add(expr);
                                }
                                closeParen = this.jj_consume_token(34);
                                FunctionNode fnNode = new FunctionNode(ident.identifier(), ident.location().extend(this.createSrcLoc(closeParen)));
                                fnNode.addChildren((List<? extends ExprNode>)params);
                                if ("" == null) break block3;
                                return fnNode;
                            }
                            default: {
                                this.jj_la1[25] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                    }
                    default: {
                        this.jj_la1[26] = this.jj_gen;
                    }
                }
                closeParen = this.jj_consume_token(34);
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
            }
        }
        if (openParen == null && "" != null) {
            return new GlobalNode(ident.identifier(), ident.location());
        }
        if ("" != null) {
            return new FunctionNode(ident.identifier(), ident.location().extend(this.createSrcLoc(closeParen)));
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode CollectionLiteral() throws ParseException {
        AbstractCollection items = ImmutableList.of();
        Token begin = this.jj_consume_token(29);
        block0 : switch (this.jj_nt.kind) {
            case 11: {
                this.jj_consume_token(11);
                Token end = this.jj_consume_token(30);
                if ("" == null) break;
                return new MapLiteralNode((List<ExprNode>)((Object)items), this.createSrcLoc(begin, end));
            }
            case 30: {
                Token end = this.jj_consume_token(30);
                if ("" == null) break;
                return new ListLiteralNode((List<ExprNode>)((Object)items), this.createSrcLoc(begin, end));
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 22: 
            case 26: 
            case 29: 
            case 33: 
            case 35: 
            case 36: 
            case 37: {
                ExprNode itemExpr = this.MapKeyOrExpr();
                items = new ArrayList();
                items.add(itemExpr);
                if (this.jj_2_1(1)) {
                    while (this.getToken((int)1).kind == 32 && this.getToken((int)2).kind != 30) {
                        this.jj_consume_token(32);
                        itemExpr = this.Expr();
                        items.add(itemExpr);
                    }
                    switch (this.jj_nt.kind) {
                        case 32: {
                            this.jj_consume_token(32);
                            break;
                        }
                        default: {
                            this.jj_la1[28] = this.jj_gen;
                        }
                    }
                    Token end = this.jj_consume_token(30);
                    if ("" == null) break;
                    return new ListLiteralNode((List<ExprNode>)((Object)items), this.createSrcLoc(begin, end));
                }
                switch (this.jj_nt.kind) {
                    case 11: {
                        this.jj_consume_token(11);
                        itemExpr = this.Expr();
                        items.add(itemExpr);
                        while (this.getToken((int)1).kind == 32 && this.getToken((int)2).kind != 30) {
                            this.jj_consume_token(32);
                            itemExpr = this.MapKeyOrExpr();
                            items.add(itemExpr);
                            this.jj_consume_token(11);
                            itemExpr = this.Expr();
                            items.add(itemExpr);
                        }
                        switch (this.jj_nt.kind) {
                            case 32: {
                                this.jj_consume_token(32);
                                break;
                            }
                            default: {
                                this.jj_la1[29] = this.jj_gen;
                            }
                        }
                        Token end = this.jj_consume_token(30);
                        if ("" == null) break block0;
                        return new MapLiteralNode((List<ExprNode>)((Object)items), this.createSrcLoc(begin, end));
                    }
                    default: {
                        this.jj_la1[30] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            default: {
                this.jj_la1[31] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode MapKeyOrExpr() throws ParseException {
        ExprNode itemExpr;
        if (this.jj_2_2(Integer.MAX_VALUE)) {
            Token ident = this.jj_consume_token(35);
            itemExpr = new GlobalNode(ident.image, this.createSrcLoc(ident));
            this.errorReporter.report(this.createSrcLoc(ident), SINGLE_IDENTIFIER_KEY_IN_MAP_LITERAL, ident.image);
        } else {
            switch (this.jj_nt.kind) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 22: 
                case 26: 
                case 29: 
                case 33: 
                case 35: 
                case 36: 
                case 37: {
                    itemExpr = this.Expr();
                    break;
                }
                default: {
                    this.jj_la1[32] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        if ("" != null) {
            return itemExpr;
        }
        throw new Error("Missing return statement in function");
    }

    private final Identifier Identifier() throws ParseException {
        Token next = null;
        StringBuilder sb = null;
        Token first = this.jj_consume_token(35);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 27: {
                    break;
                }
                default: {
                    this.jj_la1[33] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(27);
            next = this.jj_consume_token(35);
            if (sb == null) {
                sb = new StringBuilder();
                sb.append(first.image);
            }
            sb.append('.').append(next.image);
        }
        if (sb != null) {
            if ("" != null) {
                return Identifier.create(sb.toString(), this.createSrcLoc(first, next));
            }
        } else if ("" != null) {
            return Identifier.create(first.image, this.createSrcLoc(first));
        }
        throw new Error("Missing return statement in function");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    private boolean jj_3_2() {
        if (this.jj_scan_token(35)) {
            return true;
        }
        return this.jj_scan_token(11);
    }

    private boolean jj_3R_14() {
        return this.jj_scan_token(32);
    }

    private boolean jj_3_1() {
        Token xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_14());
        xsp = this.jj_scanpos = xsp;
        if (this.jj_scan_token(32)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(30);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{254, 0, 5120, 5120, 8192, 16384, 98304, 98304, 0x1E0000, 0x1E0000, 0x600000, 0x600000, 0x3800000, 0x3800000, 0x4400000, 608174334, -1207959552, 0x18000000, -1610612736, -1207959552, 536871166, 0x8000000, 0, 0, 0, 2048, 608174334, 0, 0, 0, 2048, 1681918206, 608174334, 0x8000000};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 58, 0, 0, 0, 0, 58, 0, 48, 1, 1, 5, 58, 2, 1, 1, 0, 58, 58, 0};
    }

    public ExpressionParser(InputStream stream) {
        this(stream, null);
    }

    public ExpressionParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new ExpressionParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 34; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 34; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public ExpressionParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new ExpressionParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 34; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new ExpressionParserTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 34; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public ExpressionParser(ExpressionParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 34; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(ExpressionParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 34; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = this.jj_nt;
        this.jj_nt = this.token.next != null ? this.jj_nt.next : (this.jj_nt.next = this.token_source.getNextToken());
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.jj_nt = this.token;
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.jj_nt;
        this.jj_nt = this.token.next != null ? this.jj_nt.next : (this.jj_nt.next = this.token_source.getNextToken());
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[44];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 34; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 44; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 2; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        ExpressionParser.jj_la1_init_0();
        ExpressionParser.jj_la1_init_1();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

