/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public final class SoyToJsVariableMappings {
    private final Map<String, CodeChunk.WithValue> mappings;

    private SoyToJsVariableMappings(ImmutableMap<String, ? extends CodeChunk.WithValue> initialMappings) {
        this.mappings = new HashMap<String, CodeChunk.WithValue>(initialMappings);
    }

    public static SoyToJsVariableMappings forNewTemplate() {
        return new SoyToJsVariableMappings(ImmutableMap.of());
    }

    @VisibleForTesting
    static SoyToJsVariableMappings startingWith(ImmutableMap<String, ? extends CodeChunk.WithValue> initialMappings) {
        return new SoyToJsVariableMappings(initialMappings);
    }

    public SoyToJsVariableMappings put(String var, CodeChunk.WithValue translation) {
        this.mappings.put(var, translation);
        return this;
    }

    public CodeChunk.WithValue get(String name) {
        return Preconditions.checkNotNull(this.mappings.get(name));
    }

    @Nullable
    public CodeChunk.WithValue maybeGet(String name) {
        return this.mappings.get(name);
    }
}

