/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.passes.CombineConsecutiveRawTextNodesVisitor;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForeachNode;
import com.google.template.soy.soytree.HtmlAttributeNode;
import com.google.template.soy.soytree.HtmlAttributeValueNode;
import com.google.template.soy.soytree.HtmlCloseTagNode;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.ArrayList;
import java.util.List;

final class DesugarHtmlNodesPass
extends CompilerFilePass {
    DesugarHtmlNodesPass() {
    }

    @Override
    public void run(SoyFileNode file, IdGenerator idGenerator) {
        new RewritingVisitor(idGenerator).exec(file);
        new CombineConsecutiveRawTextNodesVisitor(idGenerator).exec(file);
    }

    private static final class RewritingVisitor
    extends AbstractSoyNodeVisitor<Void> {
        private final IdGenerator idGenerator;
        boolean needsSpaceForAttribute;
        final List<SoyNode.StandaloneNode> replacements = new ArrayList<SoyNode.StandaloneNode>();

        RewritingVisitor(IdGenerator idGenerator) {
            this.idGenerator = idGenerator;
        }

        @Override
        protected void visitTemplateNode(TemplateNode node) {
            this.needsSpaceForAttribute = false;
            this.visitChildren(node);
        }

        @Override
        protected void visitHtmlCloseTagNode(HtmlCloseTagNode node) {
            this.needsSpaceForAttribute = true;
            this.visitChildren(node);
            this.needsSpaceForAttribute = false;
            this.replacements.add(this.createPrefix("</", node));
            this.replacements.add(node.getTagName().getNode());
            this.replacements.addAll(node.getChildren());
            this.replacements.add(this.createSuffix(">", node));
        }

        @Override
        protected void visitHtmlOpenTagNode(HtmlOpenTagNode node) {
            this.needsSpaceForAttribute = true;
            this.visitChildren(node);
            this.needsSpaceForAttribute = false;
            this.replacements.add(this.createPrefix("<", node));
            this.replacements.add(node.getTagName().getNode());
            this.replacements.addAll(node.getChildren());
            this.replacements.add(this.createSuffix(node.isSelfClosing() ? "/>" : ">", node));
        }

        @Override
        protected void visitHtmlAttributeValueNode(HtmlAttributeValueNode node) {
            this.visitChildren(node);
            HtmlAttributeValueNode.Quotes quotes = node.getQuotes();
            if (quotes == HtmlAttributeValueNode.Quotes.NONE) {
                this.replacements.addAll(node.getChildren());
            } else {
                this.replacements.add(this.createPrefix(quotes.getQuotationCharacter(), node));
                this.replacements.addAll(node.getChildren());
                this.replacements.add(this.createSuffix(quotes.getQuotationCharacter(), node));
            }
        }

        private RawTextNode createPrefix(String prefix, SoyNode context) {
            SourceLocation location = context.getSourceLocation().getBeginLocation();
            if (prefix.length() > 1) {
                location = location.offsetEndCol(prefix.length() - 1);
            }
            return new RawTextNode(this.idGenerator.genId(), prefix, location);
        }

        private RawTextNode createSuffix(String suffix, SoyNode context) {
            SourceLocation location = context.getSourceLocation().getEndLocation();
            if (suffix.length() > 1) {
                location = location.offsetStartCol(suffix.length() - 1);
            }
            return new RawTextNode(this.idGenerator.genId(), suffix, location);
        }

        @Override
        protected void visitHtmlAttributeNode(HtmlAttributeNode node) {
            this.visitChildren(node);
            if (this.needsSpaceForAttribute) {
                this.replacements.add(new RawTextNode(this.idGenerator.genId(), " ", node.getSourceLocation().getBeginLocation()));
            } else {
                this.needsSpaceForAttribute = true;
            }
            this.replacements.add((SoyNode.StandaloneNode)node.getChild(0));
            if (node.hasValue()) {
                this.replacements.add(new RawTextNode(this.idGenerator.genId(), "=", node.getEqualsLocation()));
                this.replacements.addAll(node.getChildren().subList(1, node.numChildren()));
            }
        }

        @Override
        protected void visitCallParamContentNode(CallParamContentNode node) {
            boolean oldInTag = this.needsSpaceForAttribute;
            this.needsSpaceForAttribute = false;
            this.visitChildren(node);
            this.needsSpaceForAttribute = oldInTag;
        }

        @Override
        protected void visitLetContentNode(LetContentNode node) {
            boolean prev = this.needsSpaceForAttribute;
            this.needsSpaceForAttribute = false;
            this.visitChildren(node);
            this.needsSpaceForAttribute = prev;
        }

        @Override
        protected void visitIfNode(IfNode node) {
            this.visitControlFlowBranches(node.getChildren());
        }

        @Override
        protected void visitForNode(ForNode node) {
            this.visitControlFlowBranches(ImmutableList.of(node));
        }

        @Override
        protected void visitForeachNode(ForeachNode node) {
            this.visitControlFlowBranches(node.getChildren());
        }

        @Override
        protected void visitSwitchNode(SwitchNode node) {
            this.visitControlFlowBranches(node.getChildren());
        }

        private void visitControlFlowBranches(List<SoyNode.BlockNode> branches) {
            boolean start = this.needsSpaceForAttribute;
            boolean end = this.needsSpaceForAttribute;
            for (SoyNode.BlockNode child : branches) {
                this.visitChildren(child);
                end |= this.needsSpaceForAttribute;
                this.needsSpaceForAttribute = start;
            }
            this.needsSpaceForAttribute = end;
        }

        @Override
        protected void visitSoyNode(SoyNode node) {
            if (node instanceof SoyNode.ParentSoyNode) {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
        }

        @Override
        protected void visitChildren(SoyNode.ParentSoyNode<?> node) {
            if (node instanceof SoyNode.BlockNode) {
                SoyNode.BlockNode blockNode = (SoyNode.BlockNode)node;
                List children = node.getChildren();
                for (int i = 0; i < children.size(); ++i) {
                    this.visit((SoyNode)children.get(i));
                    if (this.replacements.isEmpty()) continue;
                    blockNode.removeChild(i);
                    blockNode.addChildren(i, this.replacements);
                    i += this.replacements.size() - 1;
                    this.replacements.clear();
                }
            } else {
                super.visitChildren(node);
            }
            Preconditions.checkState(this.replacements.isEmpty());
        }
    }
}

