/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared.internal;

import com.google.common.collect.ImmutableMap;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.multibindings.Multibinder;
import com.google.template.soy.basicdirectives.BasicDirectivesModule;
import com.google.template.soy.basicfunctions.BasicFunctionsModule;
import com.google.template.soy.bididirectives.BidiDirectivesModule;
import com.google.template.soy.bidifunctions.BidiFunctionsModule;
import com.google.template.soy.coredirectives.CoreDirectivesModule;
import com.google.template.soy.data.SoyValueConverter;
import com.google.template.soy.data.SoyValueHelper;
import com.google.template.soy.i18ndirectives.I18nDirectivesModule;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.shared.internal.ApiCallScope;
import com.google.template.soy.shared.internal.FunctionAdapters;
import com.google.template.soy.shared.internal.GuiceSimpleScope;
import com.google.template.soy.shared.restricted.ApiCallScopeBindingAnnotations;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.shared.restricted.SoyJavaPrintDirective;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.types.SoyTypeProvider;
import com.google.template.soy.types.SoyTypeRegistry;
import java.util.Set;
import javax.inject.Singleton;

public final class SharedModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.install(new CoreDirectivesModule());
        this.install(new BasicDirectivesModule());
        this.install(new BidiDirectivesModule());
        this.install(new BasicFunctionsModule());
        this.install(new BidiFunctionsModule());
        this.install(new I18nDirectivesModule());
        GuiceSimpleScope apiCallScope = new GuiceSimpleScope();
        this.bindScope(ApiCallScope.class, apiCallScope);
        this.bind(GuiceSimpleScope.class).annotatedWith(ApiCallScopeBindingAnnotations.ApiCall.class).toInstance(apiCallScope);
        this.bind(String.class).annotatedWith(ApiCallScopeBindingAnnotations.LocaleString.class).toProvider(GuiceSimpleScope.getUnscopedProvider()).in(ApiCallScope.class);
        this.bind(BidiGlobalDir.class).toProvider(GuiceSimpleScope.getUnscopedProvider()).in(ApiCallScope.class);
        Multibinder.newSetBinder(this.binder(), SoyTypeProvider.class);
        this.bind(SoyTypeRegistry.class).in(Singleton.class);
        this.bind(SoyValueConverter.class).in(Singleton.class);
        this.bind(SoyValueHelper.class);
    }

    @Provides
    @Singleton
    ImmutableMap<String, ? extends SoyFunction> provideSoyFunctionsMap(Set<SoyFunction> soyFunctionsSet) {
        ImmutableMap.Builder<String, SoyFunction> mapBuilder = ImmutableMap.builder();
        for (SoyFunction function : soyFunctionsSet) {
            mapBuilder.put(function.getName(), function);
        }
        return mapBuilder.build();
    }

    @Provides
    @Singleton
    ImmutableMap<String, ? extends SoyPrintDirective> provideSoyDirectivesMap(Set<SoyPrintDirective> soyDirectivesSet) {
        ImmutableMap.Builder<String, SoyPrintDirective> mapBuilder = ImmutableMap.builder();
        for (SoyPrintDirective directive : soyDirectivesSet) {
            mapBuilder.put(directive.getName(), directive);
        }
        return mapBuilder.build();
    }

    @Provides
    @Singleton
    ImmutableMap<String, ? extends SoyJavaPrintDirective> provideSoyJavaDirectivesMap(Set<SoyPrintDirective> soyDirectivesSet) {
        return FunctionAdapters.buildSpecificSoyDirectivesMap(soyDirectivesSet, SoyJavaPrintDirective.class);
    }

    public boolean equals(Object other) {
        return other != null && this.getClass().equals(other.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

