/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.prolog_cafe.builtin;

import com.googlecode.prolog_cafe.exceptions.IllegalDomainException;
import com.googlecode.prolog_cafe.exceptions.IllegalTypeException;
import com.googlecode.prolog_cafe.exceptions.PInstantiationException;
import com.googlecode.prolog_cafe.lang.ClosureTerm;
import com.googlecode.prolog_cafe.lang.DoubleTerm;
import com.googlecode.prolog_cafe.lang.IntegerTerm;
import com.googlecode.prolog_cafe.lang.JavaObjectTerm;
import com.googlecode.prolog_cafe.lang.ListTerm;
import com.googlecode.prolog_cafe.lang.Operation;
import com.googlecode.prolog_cafe.lang.Predicate;
import com.googlecode.prolog_cafe.lang.Prolog;
import com.googlecode.prolog_cafe.lang.StructureTerm;
import com.googlecode.prolog_cafe.lang.SymbolTerm;
import com.googlecode.prolog_cafe.lang.Term;
import com.googlecode.prolog_cafe.lang.VariableTerm;

public class PRED_$univ_2
extends Predicate.P2 {
    private static final SymbolTerm SYM_DOT = SymbolTerm.intern(".");
    private static final SymbolTerm SYM_NIL = Prolog.Nil;

    public PRED_$univ_2(Term term, Term term2, Operation operation) {
        this.arg1 = term;
        this.arg2 = term2;
        this.cont = operation;
    }

    @Override
    public String toString() {
        return "=..(" + this.arg1 + "," + this.arg2 + ")";
    }

    @Override
    public Operation exec(Prolog prolog) {
        prolog.setB0();
        Term term = this.arg1;
        Term term2 = this.arg2;
        term = term.dereference();
        if (term instanceof SymbolTerm || term instanceof IntegerTerm || term instanceof DoubleTerm || term instanceof JavaObjectTerm || term instanceof ClosureTerm) {
            if (!term2.unify(new ListTerm(term, SYM_NIL), prolog.trail)) {
                return prolog.fail();
            }
        } else if (term instanceof ListTerm) {
            ListTerm listTerm = new ListTerm(((ListTerm)term).cdr(), SYM_NIL);
            listTerm = new ListTerm(((ListTerm)term).car(), listTerm);
            if (!term2.unify(listTerm = new ListTerm(SYM_DOT, listTerm), prolog.trail)) {
                return prolog.fail();
            }
        } else if (term instanceof StructureTerm) {
            SymbolTerm symbolTerm = SymbolTerm.create(((StructureTerm)term).functor().name());
            Term[] termArray = ((StructureTerm)term).args();
            Term term3 = SYM_NIL;
            for (int i = termArray.length; i > 0; --i) {
                term3 = new ListTerm(termArray[i - 1], term3);
            }
            if (!term2.unify(new ListTerm(symbolTerm, term3), prolog.trail)) {
                return prolog.fail();
            }
        } else if (term instanceof VariableTerm) {
            if ((term2 = term2.dereference()) instanceof VariableTerm) {
                throw new PInstantiationException(this, 2);
            }
            if (term2.equals(SYM_NIL)) {
                throw new IllegalDomainException(this, 2, "non_empty_list", term2);
            }
            if (!(term2 instanceof ListTerm)) {
                throw new IllegalTypeException(this, 2, "list", term2);
            }
            Term term4 = ((ListTerm)term2).car().dereference();
            Term term5 = ((ListTerm)term2).cdr().dereference();
            if (term4 instanceof VariableTerm) {
                throw new PInstantiationException(this, 2);
            }
            if (term5.equals(SYM_NIL)) {
                if (term4 instanceof SymbolTerm || term4 instanceof IntegerTerm || term4 instanceof DoubleTerm || term4 instanceof JavaObjectTerm || term4 instanceof ClosureTerm) {
                    if (!term.unify(term4, prolog.trail)) {
                        return prolog.fail();
                    }
                    return this.cont;
                }
                throw new IllegalTypeException(this, 2, "atomic", term4);
            }
            if (!(term4 instanceof SymbolTerm)) {
                throw new IllegalTypeException(this, 2, "atom", term4);
            }
            Term term6 = term5;
            while (!term6.equals(SYM_NIL)) {
                if (term6 instanceof VariableTerm) {
                    throw new PInstantiationException(this, 2);
                }
                if (!(term6 instanceof ListTerm)) {
                    throw new IllegalTypeException(this, 2, "list", term2);
                }
                term6 = ((ListTerm)term6).cdr().dereference();
            }
            int n = ((ListTerm)term2).length() - 1;
            SymbolTerm symbolTerm = SymbolTerm.create(((SymbolTerm)term4).name(), n);
            Term[] termArray = new Term[n];
            for (int i = 0; i < n; ++i) {
                termArray[i] = ((ListTerm)term5).car().dereference();
                term5 = ((ListTerm)term5).cdr().dereference();
            }
            if (!term.unify(new StructureTerm(symbolTerm, termArray), prolog.trail)) {
                return prolog.fail();
            }
        } else {
            return prolog.fail();
        }
        return this.cont;
    }
}

