/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.prolog_cafe.lang;

import com.googlecode.prolog_cafe.exceptions.SystemException;
import com.googlecode.prolog_cafe.lang.Prolog;
import com.googlecode.prolog_cafe.lang.Term;
import java.util.LinkedList;

public class InternalDatabase {
    protected static final int DEFAULT_SIZE = 100000;
    protected int maxContents;
    protected Term[] buffer;
    protected LinkedList<Integer> reusableIndices;
    protected int top;

    public InternalDatabase() {
        this(100000);
    }

    public InternalDatabase(int n) {
        this.maxContents = n;
        this.buffer = new Term[Math.min(this.maxContents, 100000)];
        this.reusableIndices = new LinkedList();
        this.top = -1;
    }

    InternalDatabase(Prolog prolog, InternalDatabase internalDatabase, boolean bl) {
        this.maxContents = internalDatabase.maxContents;
        this.buffer = new Term[internalDatabase.buffer.length];
        this.reusableIndices = new LinkedList<Integer>(internalDatabase.reusableIndices);
        this.top = internalDatabase.top;
        if (bl) {
            for (int i = 0; i <= this.top; ++i) {
                Term term = internalDatabase.buffer[i];
                if (term == null) continue;
                this.buffer[i] = term.copy(prolog);
            }
        } else if (0 <= this.top) {
            System.arraycopy(internalDatabase.buffer, 0, this.buffer, 0, this.top + 1);
        }
    }

    public int insert(Term term) {
        try {
            if (this.reusableIndices.isEmpty()) {
                this.buffer[++this.top] = term;
                return this.top;
            }
            int n = this.reusableIndices.remove();
            this.buffer[n] = term;
            return n;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (this.maxContents <= this.buffer.length) {
                throw new SystemException("internal database capacity reached");
            }
            int n = this.buffer.length;
            Term[] termArray = new Term[Math.min(n + 10000, this.maxContents)];
            for (int i = 0; i < n; ++i) {
                termArray[i] = this.buffer[i];
            }
            this.buffer = termArray;
            this.buffer[this.top] = term;
            return this.top;
        }
    }

    public Term get(int n) {
        return this.buffer[n];
    }

    public Term erase(int n) {
        Term term = this.buffer[n];
        this.buffer[n] = null;
        this.reusableIndices.add(n);
        return term;
    }

    private boolean empty() {
        return this.top == -1;
    }

    public void show() {
        if (this.empty()) {
            System.out.println("{internal database is empty!}");
        }
        System.out.println("{reusable indices: " + this.reusableIndices.toString() + "}");
        for (int i = 0; i <= this.top; ++i) {
            System.out.print("internal database[" + i + "]: ");
            System.out.println(this.buffer[i]);
        }
    }
}

