/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.prolog_cafe.lang;

import com.googlecode.prolog_cafe.exceptions.HaltException;
import com.googlecode.prolog_cafe.exceptions.PrologException;
import com.googlecode.prolog_cafe.exceptions.ReductionLimitException;
import com.googlecode.prolog_cafe.lang.HashtableOfTerm;
import com.googlecode.prolog_cafe.lang.InternalDatabase;
import com.googlecode.prolog_cafe.lang.JavaObjectTerm;
import com.googlecode.prolog_cafe.lang.Operation;
import com.googlecode.prolog_cafe.lang.Predicate;
import com.googlecode.prolog_cafe.lang.Prolog;
import com.googlecode.prolog_cafe.lang.PrologClassLoader;
import com.googlecode.prolog_cafe.lang.PrologMachineCopy;
import com.googlecode.prolog_cafe.lang.Success;
import com.googlecode.prolog_cafe.lang.SymbolTerm;
import com.googlecode.prolog_cafe.lang.Term;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.PushbackReader;
import java.io.Writer;
import java.util.Set;

public abstract class PrologControl {
    protected Prolog engine;
    protected Operation code;
    private long reductionLimit = 0x100000L;
    private long reductionsUsed;

    public PrologControl() {
        this.engine = new Prolog(this);
    }

    public PrologControl(PrologMachineCopy prologMachineCopy) {
        this.engine = new Prolog(this, prologMachineCopy);
    }

    public boolean isEnabled(Prolog.Feature feature) {
        return this.engine.features.contains((Object)feature);
    }

    public void setEnabled(Prolog.Feature feature, boolean bl) {
        if (bl) {
            this.engine.features.add(feature);
        } else {
            this.engine.features.remove((Object)feature);
        }
    }

    public void setEnabled(Set<Prolog.Feature> set, boolean bl) {
        if (bl) {
            this.engine.features.addAll(set);
        } else {
            this.engine.features.removeAll(set);
        }
    }

    public int getMaxDatabaseSize() {
        if (this.engine.internalDB != null) {
            return this.engine.internalDB.maxContents;
        }
        return 100000;
    }

    public void setMaxDatabaseSize(int n) {
        if (this.engine.internalDB != null) {
            this.engine.internalDB.maxContents = n;
        } else {
            this.engine.internalDB = new InternalDatabase(n);
        }
    }

    public PrologClassLoader getPrologClassLoader() {
        if (this.engine.pcl == null) {
            this.engine.pcl = new PrologClassLoader();
        }
        return this.engine.pcl;
    }

    public void setPrologClassLoader(PrologClassLoader prologClassLoader) {
        this.engine.pcl = prologClassLoader;
    }

    public void configureUserIO(InputStream inputStream, OutputStream outputStream, OutputStream outputStream2) {
        if (this.engine.streamManager == null) {
            this.engine.streamManager = new HashtableOfTerm(7);
        }
        if (inputStream != null) {
            this.engine.streamManager.put(SymbolTerm.intern("user_input"), new JavaObjectTerm(new PushbackReader(new BufferedReader(new InputStreamReader(inputStream)), 3)));
        }
        if (outputStream != null) {
            this.engine.streamManager.put(SymbolTerm.intern("user_output"), new JavaObjectTerm(new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(outputStream)), true)));
        }
        if (outputStream2 != null) {
            this.engine.streamManager.put(SymbolTerm.intern("user_error"), new JavaObjectTerm(new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(outputStream2)), true)));
        }
    }

    public void setPredicate(Predicate predicate) {
        predicate.cont = Success.SUCCESS;
        this.code = predicate;
    }

    public void setPredicate(String string, String string2, Term ... termArray) {
        this.setPredicate(this.getPrologClassLoader().predicate(string, string2, termArray));
    }

    public void setPredicate(Term term) {
        this.setPredicate("com.googlecode.prolog_cafe.builtin", "call", term);
    }

    protected abstract void success();

    protected abstract void fail();

    public abstract boolean isEngineStopped();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executePredicate() throws PrologException {
        Prolog prolog = this.engine;
        Operation operation = this.code;
        long l = this.reductionLimit;
        try {
            prolog.init();
            do {
                if (this.isEngineStopped()) {
                    return;
                }
                if (--l <= 0L) {
                    throw new ReductionLimitException(this.reductionLimit);
                }
                operation = operation.exec(prolog);
            } while (prolog.halt == 0);
            if (prolog.halt != 1) {
                throw new HaltException(prolog.halt - 1);
            }
        }
        finally {
            this.reductionsUsed = this.reductionLimit - l;
            this.code = operation;
            SymbolTerm.gc();
        }
    }

    public long getReductions() {
        return this.reductionsUsed;
    }

    public void setReductionLimit(long l) {
        this.reductionLimit = Math.max(0L, l);
    }

    public void printStackTrace(Throwable throwable) {
        throwable.printStackTrace();
    }
}

