/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth.hostbased;

import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.Pair;

@FunctionalInterface
public interface HostKeyIdentityProvider {
    public Iterable<Pair<KeyPair, List<X509Certificate>>> loadHostKeys();

    public static Iterator<Pair<KeyPair, List<X509Certificate>>> iteratorOf(HostKeyIdentityProvider provider) {
        return GenericUtils.iteratorOf(provider == null ? null : provider.loadHostKeys());
    }

    public static HostKeyIdentityProvider wrap(KeyPair ... pairs) {
        return HostKeyIdentityProvider.wrap(GenericUtils.asList(pairs));
    }

    public static HostKeyIdentityProvider wrap(Iterable<? extends KeyPair> pairs) {
        return () -> () -> {
            Iterator iter = GenericUtils.iteratorOf(pairs);
            return GenericUtils.wrapIterator(iter, kp -> new Pair((KeyPair)kp, Collections.emptyList()));
        };
    }
}

