/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd;

import com.google.gerrit.httpd.GerritAuthModule;
import com.google.gerrit.httpd.GitOverHttpServlet;
import com.google.gerrit.server.config.AuthConfig;
import com.google.gerrit.server.config.DownloadConfig;
import com.google.inject.Inject;
import com.google.inject.servlet.ServletModule;

public class GitOverHttpModule
extends ServletModule {
    private final AuthConfig authConfig;
    private final DownloadConfig downloadConfig;

    @Inject
    GitOverHttpModule(AuthConfig authConfig, DownloadConfig downloadConfig) {
        this.authConfig = authConfig;
        this.downloadConfig = downloadConfig;
    }

    @Override
    protected void configureServlets() {
        if (this.downloadConfig.getDownloadSchemes().contains("anonymous http") || this.downloadConfig.getDownloadSchemes().contains("http")) {
            this.filterRegex(GitOverHttpServlet.URL_REGEX, new String[0]).through(GerritAuthModule.retreiveAuthFilterFromConfig(this.authConfig));
            this.serveRegex(GitOverHttpServlet.URL_REGEX, new String[0]).with(GitOverHttpServlet.class);
        }
    }
}

