/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class HtmlDomUtil {
    public static final Charset ENC = StandardCharsets.UTF_8;
    public static final String HTML_STRICT = "-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd";

    public static byte[] toUTF8(Document hostDoc) throws IOException {
        return HtmlDomUtil.toString(hostDoc).getBytes(ENC);
    }

    public static byte[] compress(byte[] raw) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gz = new GZIPOutputStream(out);
        gz.write(raw);
        gz.finish();
        gz.flush();
        return out.toByteArray();
    }

    public static String toString(Document hostDoc) throws IOException {
        try {
            StringWriter out = new StringWriter();
            DOMSource domSource = new DOMSource(hostDoc);
            StreamResult streamResult = new StreamResult(out);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer serializer = tf.newTransformer();
            serializer.setOutputProperty("encoding", ENC.name());
            serializer.setOutputProperty("method", "html");
            serializer.setOutputProperty("indent", "no");
            serializer.setOutputProperty("doctype-public", HTML_STRICT);
            serializer.transform(domSource, streamResult);
            return out.toString();
        }
        catch (TransformerException e) {
            IOException r = new IOException("Error transforming page");
            r.initCause(e);
            throw r;
        }
    }

    public static Element find(Node parent, String name) {
        NodeList list = parent.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Element e;
            Node n = list.item(i);
            if (n instanceof Element && name.equals((e = (Element)n).getAttribute("id"))) {
                return e;
            }
            Element r = HtmlDomUtil.find(n, name);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    public static void addHidden(Element form, String name, String value) {
        Element in = form.getOwnerDocument().createElement("input");
        in.setAttribute("type", "hidden");
        in.setAttribute("name", name);
        in.setAttribute("value", value);
        form.appendChild(in);
    }

    public static Document newDocument() {
        try {
            return HtmlDomUtil.newBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Cannot create new document", e);
        }
    }

    public static Document clone(Document doc) throws IOException {
        Document d;
        try {
            d = HtmlDomUtil.newBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Cannot clone document");
        }
        Node n = d.importNode(doc.getDocumentElement(), true);
        d.appendChild(n);
        return d;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Document parseFile(Class<?> context, String name) throws IOException {
        try (InputStream in = context.getResourceAsStream(name);){
            if (in == null) {
                Document document = null;
                return document;
            }
            Document doc = HtmlDomUtil.newBuilder().parse(in);
            HtmlDomUtil.compact(doc);
            Document document = doc;
            return document;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new IOException("Error reading " + name, e);
        }
    }

    private static void compact(Document doc) {
        try {
            String expr = "//text()[normalize-space(.) = '']";
            XPathFactory xp = XPathFactory.newInstance();
            XPathExpression e = xp.newXPath().compile(expr);
            NodeList empty = (NodeList)e.evaluate(doc, XPathConstants.NODESET);
            for (int i = 0; i < empty.getLength(); ++i) {
                Node node = empty.item(i);
                node.getParentNode().removeChild(node);
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readFile(Class<?> context, String name) throws IOException {
        try (InputStream in = context.getResourceAsStream(name);){
            if (in == null) {
                String string = null;
                return string;
            }
            String string = new String(ByteStreams.toByteArray(in), ENC);
            return string;
        }
        catch (IOException e) {
            throw new IOException("Error reading " + name, e);
        }
    }

    public static Document parseFile(Path path) throws IOException {
        Document document;
        block9: {
            InputStream in = Files.newInputStream(path, new OpenOption[0]);
            Throwable throwable = null;
            try {
                Document doc = HtmlDomUtil.newBuilder().parse(in);
                HtmlDomUtil.compact(doc);
                document = doc;
                if (in == null) break block9;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (in != null) {
                            HtmlDomUtil.$closeResource(throwable, in);
                        }
                        throw throwable3;
                    }
                }
                catch (NoSuchFileException e) {
                    return null;
                }
                catch (IOException | ParserConfigurationException | SAXException e) {
                    throw new IOException("Error reading " + path, e);
                }
            }
            HtmlDomUtil.$closeResource(throwable, in);
        }
        return document;
    }

    public static String readFile(Path parentDir, String name) throws IOException {
        String string;
        block10: {
            if (parentDir == null) {
                return null;
            }
            Path path = parentDir.resolve(name);
            InputStream in = Files.newInputStream(path, new OpenOption[0]);
            Throwable throwable = null;
            try {
                string = new String(ByteStreams.toByteArray(in), ENC);
                if (in == null) break block10;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (in != null) {
                            HtmlDomUtil.$closeResource(throwable, in);
                        }
                        throw throwable3;
                    }
                }
                catch (NoSuchFileException e) {
                    return null;
                }
                catch (IOException e) {
                    throw new IOException("Error reading " + path, e);
                }
            }
            HtmlDomUtil.$closeResource(throwable, in);
        }
        return string;
    }

    private static DocumentBuilder newBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setExpandEntityReferences(false);
        factory.setIgnoringComments(true);
        factory.setCoalescing(true);
        return factory.newDocumentBuilder();
    }
}

