/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.restapi;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.BinaryResult;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gerrit.httpd.restapi.RestApiServlet;
import com.google.gerrit.util.cli.CmdLineParser;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gwtexpui.server.CacheHeaders;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kohsuke.args4j.CmdLineException;

class ParameterParser {
    private static final ImmutableSet<String> RESERVED_KEYS = ImmutableSet.of("pp", "prettyPrint", "strict", "callback", "alt", "fields", new String[0]);
    private final CmdLineParser.Factory parserFactory;

    @Inject
    ParameterParser(CmdLineParser.Factory pf) {
        this.parserFactory = pf;
    }

    <T> boolean parse(T param, ListMultimap<String, String> in, HttpServletRequest req, HttpServletResponse res) throws IOException {
        CmdLineParser clp;
        block3: {
            clp = this.parserFactory.create(param);
            try {
                clp.parseOptionMap(in);
            }
            catch (NumberFormatException | CmdLineException e) {
                if (clp.wasHelpRequestedByOption()) break block3;
                RestApiServlet.replyError(req, res, 400, e.getMessage(), e);
                return false;
            }
        }
        if (clp.wasHelpRequestedByOption()) {
            StringWriter msg = new StringWriter();
            clp.printQueryStringUsage(req.getRequestURI(), msg);
            msg.write(10);
            msg.write(10);
            clp.printUsage(msg, null);
            msg.write(10);
            CacheHeaders.setNotCacheable(res);
            RestApiServlet.replyBinaryResult(req, res, BinaryResult.create(msg.toString()).setContentType("text/plain"));
            return false;
        }
        return true;
    }

    static void splitQueryString(String queryString, ListMultimap<String, String> config, ListMultimap<String, String> params) {
        if (!Strings.isNullOrEmpty(queryString)) {
            for (String kvPair : Splitter.on('&').split(queryString)) {
                String val;
                Iterator<String> i = Splitter.on('=').limit(2).split(kvPair).iterator();
                String key = Url.decode(i.next());
                String string = val = i.hasNext() ? Url.decode(i.next()) : "";
                if (RESERVED_KEYS.contains(key)) {
                    config.put(key, val);
                    continue;
                }
                params.put(key, val);
            }
        }
    }

    private static Set<String> query(HttpServletRequest req) {
        HashSet<String> params = new HashSet<String>();
        if (!Strings.isNullOrEmpty(req.getQueryString())) {
            for (String kvPair : Splitter.on('&').split(req.getQueryString())) {
                params.add(Iterables.getFirst(Splitter.on('=').limit(2).split(kvPair), null));
            }
        }
        return params;
    }

    static JsonObject formToJson(HttpServletRequest req) throws BadRequestException {
        Map<String, String[]> map = req.getParameterMap();
        return ParameterParser.formToJson(map, ParameterParser.query(req));
    }

    @VisibleForTesting
    static JsonObject formToJson(Map<String, String[]> map, Set<String> query) throws BadRequestException {
        JsonObject inputObject = new JsonObject();
        for (Map.Entry<String, String[]> ent : map.entrySet()) {
            String key = ent.getKey();
            String[] values = ent.getValue();
            if (query.contains(key) || values.length == 0) continue;
            JsonObject obj = inputObject;
            int dot = key.indexOf(46);
            if (0 <= dot) {
                String property = key.substring(0, dot);
                JsonElement e = inputObject.get(property);
                if (e == null) {
                    obj = new JsonObject();
                    inputObject.add(property, obj);
                } else if (e.isJsonObject()) {
                    obj = e.getAsJsonObject();
                } else {
                    throw new BadRequestException(String.format("key %s conflicts with %s", key, property));
                }
                key = key.substring(dot + 1);
            }
            if (obj.get(key) != null) {
                throw new BadRequestException("invalid form input, use JSON instead");
            }
            if (values.length == 1) {
                obj.addProperty(key, values[0]);
                continue;
            }
            JsonArray list = new JsonArray();
            for (String v : values) {
                list.add(new JsonPrimitive(v));
            }
            obj.add(key, list);
        }
        return inputObject;
    }
}

