/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.rpc.doc;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableListMultimap;
import com.google.gerrit.httpd.restapi.RestApiServlet;
import com.google.gerrit.server.documentation.QueryDocumentationExecutor;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class QueryDocumentationFilter
implements Filter {
    private final Logger log = LoggerFactory.getLogger(QueryDocumentationFilter.class);
    private final QueryDocumentationExecutor searcher;

    @Inject
    QueryDocumentationFilter(QueryDocumentationExecutor searcher) {
        this.searcher = searcher;
    }

    @Override
    public void init(FilterConfig filterConfig) {
    }

    @Override
    public void destroy() {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        if ("GET".equals(req.getMethod()) && !Strings.isNullOrEmpty(req.getParameter("q"))) {
            HttpServletResponse rsp = (HttpServletResponse)response;
            try {
                List<QueryDocumentationExecutor.DocResult> result = this.searcher.doQuery(request.getParameter("q"));
                RestApiServlet.replyJson(req, rsp, ImmutableListMultimap.of(), result);
            }
            catch (QueryDocumentationExecutor.DocQueryException e) {
                this.log.error("Doc search failed:", e);
                rsp.sendError(500);
            }
        } else {
            chain.doFilter(request, response);
        }
    }
}

