/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.extensions.annotations.CapabilityScope;
import com.google.gerrit.extensions.annotations.RequiresAnyCapability;
import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.CapabilityControl;
import com.google.inject.Provider;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CapabilityUtils {
    private static final Logger log = LoggerFactory.getLogger(CapabilityUtils.class);

    public static void checkRequiresCapability(Provider<CurrentUser> userProvider, String pluginName, Class<?> clazz) throws AuthException {
        CapabilityUtils.checkRequiresCapability(userProvider.get(), pluginName, clazz);
    }

    public static void checkRequiresCapability(CurrentUser user, String pluginName, Class<?> clazz) throws AuthException {
        RequiresCapability rc = CapabilityUtils.getClassAnnotation(clazz, RequiresCapability.class);
        RequiresAnyCapability rac = CapabilityUtils.getClassAnnotation(clazz, RequiresAnyCapability.class);
        if (rc != null && rac != null) {
            log.error("Class {} uses both @{} and @{}", clazz.getName(), RequiresCapability.class.getSimpleName(), RequiresAnyCapability.class.getSimpleName());
            throw new AuthException("cannot check capability");
        }
        CapabilityControl ctl = user.getCapabilities();
        if (ctl.canAdministrateServer()) {
            return;
        }
        CapabilityUtils.checkRequiresCapability(ctl, pluginName, clazz, rc);
        CapabilityUtils.checkRequiresAnyCapability(ctl, pluginName, clazz, rac);
    }

    private static void checkRequiresCapability(CapabilityControl ctl, String pluginName, Class<?> clazz, RequiresCapability rc) throws AuthException {
        if (rc == null) {
            return;
        }
        String capability = CapabilityUtils.resolveCapability(pluginName, rc.value(), rc.scope(), clazz);
        if (!ctl.canPerform(capability)) {
            throw new AuthException(String.format("Capability %s is required to access this resource", capability));
        }
    }

    private static void checkRequiresAnyCapability(CapabilityControl ctl, String pluginName, Class<?> clazz, RequiresAnyCapability rac) throws AuthException {
        if (rac == null) {
            return;
        }
        if (rac.value().length == 0) {
            log.error("Class {} uses @{} with no capabilities listed", (Object)clazz.getName(), (Object)RequiresAnyCapability.class.getSimpleName());
            throw new AuthException("cannot check capability");
        }
        for (String capability : rac.value()) {
            if (!ctl.canPerform(capability = CapabilityUtils.resolveCapability(pluginName, capability, rac.scope(), clazz))) continue;
            return;
        }
        throw new AuthException("One of the following capabilities is required to access this resource: " + Arrays.asList(rac.value()));
    }

    private static String resolveCapability(String pluginName, String capability, CapabilityScope scope, Class<?> clazz) throws AuthException {
        if (!(pluginName == null || "gerrit".equals(pluginName) || scope != CapabilityScope.PLUGIN && scope != CapabilityScope.CONTEXT)) {
            capability = String.format("%s-%s", pluginName, capability);
        } else if (scope == CapabilityScope.PLUGIN) {
            log.error("Class {} uses @{}(scope={}), but is not within a plugin", clazz.getName(), RequiresCapability.class.getSimpleName(), CapabilityScope.PLUGIN.name());
            throw new AuthException("cannot check capability");
        }
        return capability;
    }

    private static <T extends Annotation> T getClassAnnotation(Class<?> clazz, Class<T> annotationClass) {
        while (clazz != null) {
            T t = clazz.getAnnotation(annotationClass);
            if (t != null) {
                return t;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }
}

