/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.hash.Hashing;
import com.google.common.primitives.Ints;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountExternalId;
import com.google.gerrit.server.account.AutoValue_ExternalId;
import com.google.gerrit.server.account.AutoValue_ExternalId_Key;
import com.google.gerrit.server.account.HashedPassword;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;

@AutoValue
public abstract class ExternalId
implements Serializable {
    private static final String USER_NAME_PATTERN_FIRST_REGEX = "[a-zA-Z0-9]";
    private static final String USER_NAME_PATTERN_REST_REGEX = "[a-zA-Z0-9.!#$%&\u2019*+=?^_`\\{|\\}~@-]";
    private static final String USER_NAME_PATTERN_LAST_REGEX = "[a-zA-Z0-9]";
    private static final String USER_NAME_PATTERN_REGEX = "^([a-zA-Z0-9][a-zA-Z0-9.!#$%&\u2019*+=?^_`\\{|\\}~@-]*[a-zA-Z0-9]|[a-zA-Z0-9])$";
    private static final Pattern USER_NAME_PATTERN = Pattern.compile("^([a-zA-Z0-9][a-zA-Z0-9.!#$%&\u2019*+=?^_`\\{|\\}~@-]*[a-zA-Z0-9]|[a-zA-Z0-9])$");
    private static final long serialVersionUID = 1L;
    private static final String EXTERNAL_ID_SECTION = "externalId";
    private static final String ACCOUNT_ID_KEY = "accountId";
    private static final String EMAIL_KEY = "email";
    private static final String PASSWORD_KEY = "password";
    public static final String SCHEME_GERRIT = "gerrit";
    public static final String SCHEME_UUID = "uuid";
    public static final String SCHEME_MAILTO = "mailto";
    public static final String SCHEME_USERNAME = "username";
    public static final String SCHEME_GPGKEY = "gpgkey";
    public static final String SCHEME_EXTERNAL = "external";

    public static boolean isValidUsername(String username) {
        return USER_NAME_PATTERN.matcher(username).matches();
    }

    public static ExternalId create(String scheme, String id, Account.Id accountId) {
        return new AutoValue_ExternalId(Key.create(scheme, id), accountId, null, null);
    }

    public static ExternalId create(String scheme, String id, Account.Id accountId, @Nullable String email, @Nullable String hashedPassword) {
        return ExternalId.create(Key.create(scheme, id), accountId, email, hashedPassword);
    }

    public static ExternalId create(Key key, Account.Id accountId) {
        return ExternalId.create(key, accountId, null, null);
    }

    public static ExternalId create(Key key, Account.Id accountId, @Nullable String email, @Nullable String hashedPassword) {
        return new AutoValue_ExternalId(key, accountId, Strings.emptyToNull(email), Strings.emptyToNull(hashedPassword));
    }

    public static ExternalId createWithPassword(Key key, Account.Id accountId, @Nullable String email, String plainPassword) {
        String hashedPassword = (plainPassword = Strings.emptyToNull(plainPassword)) != null ? HashedPassword.fromPassword(plainPassword).encode() : null;
        return ExternalId.create(key, accountId, email, hashedPassword);
    }

    public static ExternalId createUsername(String id, Account.Id accountId, String plainPassword) {
        return ExternalId.createWithPassword(Key.create(SCHEME_USERNAME, id), accountId, null, plainPassword);
    }

    public static ExternalId createWithEmail(String scheme, String id, Account.Id accountId, @Nullable String email) {
        return ExternalId.createWithEmail(Key.create(scheme, id), accountId, email);
    }

    public static ExternalId createWithEmail(Key key, Account.Id accountId, @Nullable String email) {
        return new AutoValue_ExternalId(key, accountId, Strings.emptyToNull(email), null);
    }

    public static ExternalId createEmail(Account.Id accountId, String email) {
        return ExternalId.createWithEmail(SCHEME_MAILTO, email, accountId, Preconditions.checkNotNull(email));
    }

    public static ExternalId parse(String noteId, byte[] raw) throws ConfigInvalidException {
        Config externalIdConfig = new Config();
        try {
            externalIdConfig.fromText(new String(raw, StandardCharsets.UTF_8));
        }
        catch (ConfigInvalidException e) {
            throw ExternalId.invalidConfig(noteId, e.getMessage());
        }
        Set<String> externalIdKeys = externalIdConfig.getSubsections(EXTERNAL_ID_SECTION);
        if (externalIdKeys.size() != 1) {
            throw ExternalId.invalidConfig(noteId, String.format("Expected exactly 1 %s section, found %d", EXTERNAL_ID_SECTION, externalIdKeys.size()));
        }
        String externalIdKeyStr = Iterables.getOnlyElement(externalIdKeys);
        Key externalIdKey = Key.parse(externalIdKeyStr);
        if (externalIdKey == null) {
            throw ExternalId.invalidConfig(noteId, String.format("Invalid external id: %s", externalIdKeyStr));
        }
        String accountIdStr = externalIdConfig.getString(EXTERNAL_ID_SECTION, externalIdKeyStr, ACCOUNT_ID_KEY);
        String email = externalIdConfig.getString(EXTERNAL_ID_SECTION, externalIdKeyStr, EMAIL_KEY);
        String password = externalIdConfig.getString(EXTERNAL_ID_SECTION, externalIdKeyStr, PASSWORD_KEY);
        if (accountIdStr == null) {
            throw ExternalId.invalidConfig(noteId, String.format("Missing value for %s.%s.%s", EXTERNAL_ID_SECTION, externalIdKeyStr, ACCOUNT_ID_KEY));
        }
        Integer accountId = Ints.tryParse(accountIdStr);
        if (accountId == null) {
            throw ExternalId.invalidConfig(noteId, String.format("Value %s for %s.%s.%s is invalid, expected account ID", accountIdStr, EXTERNAL_ID_SECTION, externalIdKeyStr, ACCOUNT_ID_KEY));
        }
        return new AutoValue_ExternalId(externalIdKey, new Account.Id(accountId), Strings.emptyToNull(email), Strings.emptyToNull(password));
    }

    private static ConfigInvalidException invalidConfig(String noteId, String message) {
        return new ConfigInvalidException(String.format("Invalid external id config for note %s: %s", noteId, message));
    }

    public static ExternalId from(AccountExternalId externalId) {
        if (externalId == null) {
            return null;
        }
        return new AutoValue_ExternalId(Key.parse(externalId.getExternalId()), externalId.getAccountId(), Strings.emptyToNull(externalId.getEmailAddress()), Strings.emptyToNull(externalId.getPassword()));
    }

    public static Set<ExternalId> from(Collection<AccountExternalId> externalIds) {
        if (externalIds == null) {
            return ImmutableSet.of();
        }
        return externalIds.stream().map(ExternalId::from).collect(Collectors.toSet());
    }

    public static Set<AccountExternalId> toAccountExternalIds(Collection<ExternalId> extIds) {
        return extIds.stream().map(e -> e.asAccountExternalId()).collect(Collectors.toSet());
    }

    public abstract Key key();

    public abstract Account.Id accountId();

    @Nullable
    public abstract String email();

    @Nullable
    public abstract String password();

    public boolean isScheme(String scheme) {
        return this.key().isScheme(scheme);
    }

    public AccountExternalId asAccountExternalId() {
        AccountExternalId extId = new AccountExternalId(this.accountId(), this.key().asAccountExternalIdKey());
        extId.setEmailAddress(this.email());
        extId.setPassword(this.password());
        return extId;
    }

    public String toString() {
        Config c = new Config();
        this.writeToConfig(c);
        return c.toText();
    }

    public void writeToConfig(Config c) {
        String externalIdKey = this.key().get();
        c.setInt(EXTERNAL_ID_SECTION, externalIdKey, ACCOUNT_ID_KEY, this.accountId().get());
        if (this.email() != null) {
            c.setString(EXTERNAL_ID_SECTION, externalIdKey, EMAIL_KEY, this.email());
        }
        if (this.password() != null) {
            c.setString(EXTERNAL_ID_SECTION, externalIdKey, PASSWORD_KEY, this.password());
        }
    }

    @AutoValue
    public static abstract class Key
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public static Key create(@Nullable String scheme, String id) {
            return new AutoValue_ExternalId_Key(Strings.emptyToNull(scheme), id);
        }

        public static Key from(AccountExternalId.Key externalIdKey) {
            return Key.parse(externalIdKey.get());
        }

        public static Key parse(String externalId) {
            int c = externalId.indexOf(58);
            if (c < 1 || c >= externalId.length() - 1) {
                return Key.create(null, externalId);
            }
            return Key.create(externalId.substring(0, c), externalId.substring(c + 1));
        }

        public static Set<AccountExternalId.Key> toAccountExternalIdKeys(Collection<Key> extIdKeys) {
            return extIdKeys.stream().map(k -> k.asAccountExternalIdKey()).collect(Collectors.toSet());
        }

        @Nullable
        public abstract String scheme();

        public abstract String id();

        public boolean isScheme(String scheme) {
            return scheme.equals(this.scheme());
        }

        public AccountExternalId.Key asAccountExternalIdKey() {
            if (this.scheme() != null) {
                return new AccountExternalId.Key(this.scheme(), this.id());
            }
            return new AccountExternalId.Key(this.id());
        }

        public ObjectId sha1() {
            return ObjectId.fromRaw(Hashing.sha1().hashString(this.get(), StandardCharsets.UTF_8).asBytes());
        }

        public String get() {
            if (this.scheme() != null) {
                return this.scheme() + ":" + this.id();
            }
            return this.id();
        }

        public String toString() {
            return this.get();
        }
    }
}

