/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.common.data.ContributorAgreement;
import com.google.gerrit.common.data.PermissionRule;
import com.google.gerrit.extensions.common.AgreementInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.config.AgreementJson;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.project.ProjectCache;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GetAgreements
implements RestReadView<AccountResource> {
    private static final Logger log = LoggerFactory.getLogger(GetAgreements.class);
    private final Provider<CurrentUser> self;
    private final ProjectCache projectCache;
    private final AgreementJson agreementJson;
    private final boolean agreementsEnabled;

    @Inject
    GetAgreements(Provider<CurrentUser> self, ProjectCache projectCache, AgreementJson agreementJson, @GerritServerConfig Config config) {
        this.self = self;
        this.projectCache = projectCache;
        this.agreementJson = agreementJson;
        this.agreementsEnabled = config.getBoolean("auth", "contributorAgreements", false);
    }

    public List<AgreementInfo> apply(AccountResource resource) throws RestApiException {
        if (!this.agreementsEnabled) {
            throw new MethodNotAllowedException("contributor agreements disabled");
        }
        if (!this.self.get().isIdentifiedUser()) {
            throw new AuthException("not allowed to get contributor agreements");
        }
        IdentifiedUser user = this.self.get().asIdentifiedUser();
        if (user != resource.getUser()) {
            throw new AuthException("not allowed to get contributor agreements");
        }
        ArrayList<AgreementInfo> results = new ArrayList<AgreementInfo>();
        Collection<ContributorAgreement> cas = this.projectCache.getAllProjects().getConfig().getContributorAgreements();
        for (ContributorAgreement ca : cas) {
            ArrayList<AccountGroup.UUID> groupIds = new ArrayList<AccountGroup.UUID>();
            for (PermissionRule rule : ca.getAccepted()) {
                if (rule.getAction() != PermissionRule.Action.ALLOW || rule.getGroup() == null) continue;
                if (rule.getGroup().getUUID() != null) {
                    groupIds.add(rule.getGroup().getUUID());
                    continue;
                }
                log.warn("group \"" + rule.getGroup().getName() + "\" does not exist, referenced in CLA \"" + ca.getName() + "\"");
            }
            if (!user.getEffectiveGroups().containsAnyOf(groupIds)) continue;
            results.add(this.agreementJson.format(ca));
        }
        return results;
    }
}

