/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gerrit.extensions.common.AccountExternalIdInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.ExternalId;
import com.google.gerrit.server.config.AuthConfig;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

@Singleton
public class GetExternalIds
implements RestReadView<AccountResource> {
    private final Provider<ReviewDb> db;
    private final Provider<CurrentUser> self;
    private final AuthConfig authConfig;

    @Inject
    GetExternalIds(Provider<ReviewDb> db, Provider<CurrentUser> self, AuthConfig authConfig) {
        this.db = db;
        this.self = self;
        this.authConfig = authConfig;
    }

    public List<AccountExternalIdInfo> apply(AccountResource resource) throws RestApiException, OrmException {
        if (!this.self.get().hasSameAccountId(resource.getUser())) {
            throw new AuthException("not allowed to get external IDs");
        }
        Set<ExternalId> ids = ExternalId.from(this.db.get().accountExternalIds().byAccount(resource.getUser().getAccountId()).toList());
        if (ids.isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList<AccountExternalIdInfo> result = Lists.newArrayListWithCapacity(ids.size());
        for (ExternalId id : ids) {
            AccountExternalIdInfo info = new AccountExternalIdInfo();
            info.identity = id.key().get();
            info.emailAddress = id.email();
            info.trusted = GetExternalIds.toBoolean(this.authConfig.isIdentityTrustable(Collections.singleton(id)));
            if (!id.isScheme("username")) {
                ExternalId.Key last = resource.getUser().getLastLoginExternalIdKey();
                info.canDelete = GetExternalIds.toBoolean(last == null || !last.get().equals(info.identity));
            }
            result.add(info);
        }
        return result;
    }

    private static Boolean toBoolean(boolean v) {
        return v ? Boolean.valueOf(v) : null;
    }
}

