/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountResource;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;

@Singleton
public class Index
implements RestModifyView<AccountResource, Input> {
    private final AccountCache accountCache;
    private final Provider<CurrentUser> self;

    @Inject
    Index(AccountCache accountCache, Provider<CurrentUser> self) {
        this.accountCache = accountCache;
        this.self = self;
    }

    public Response<?> apply(AccountResource rsrc, Input input) throws IOException, AuthException {
        if (!this.self.get().hasSameAccountId(rsrc.getUser()) && !this.self.get().getCapabilities().canModifyAccount()) {
            throw new AuthException("not allowed to index account");
        }
        this.accountCache.evict(rsrc.getUser().getAccountId());
        return Response.none();
    }

    public static class Input {
    }
}

