/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.common.FileInfo;
import com.google.gerrit.extensions.registration.DynamicItem;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.CacheControl;
import com.google.gerrit.extensions.restapi.ChildCollection;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.change.AccountPatchReviewStore;
import com.google.gerrit.server.change.FileInfoJson;
import com.google.gerrit.server.change.FileResource;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.change.Revisions;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.patch.PatchListCache;
import com.google.gerrit.server.patch.PatchListNotAvailableException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Files
implements ChildCollection<RevisionResource, FileResource> {
    private final DynamicMap<RestView<FileResource>> views;
    private final Provider<ListFiles> list;

    @Inject
    Files(DynamicMap<RestView<FileResource>> views, Provider<ListFiles> list) {
        this.views = views;
        this.list = list;
    }

    @Override
    public DynamicMap<RestView<FileResource>> views() {
        return this.views;
    }

    @Override
    public RestView<RevisionResource> list() throws AuthException {
        return this.list.get();
    }

    @Override
    public FileResource parse(RevisionResource rev, IdString id) {
        return new FileResource(rev, id.get());
    }

    public static final class ListFiles
    implements RestReadView<RevisionResource> {
        private static final Logger log = LoggerFactory.getLogger(ListFiles.class);
        @Option(name="--base", metaVar="revision-id")
        String base;
        @Option(name="--parent", metaVar="parent-number")
        int parentNum;
        @Option(name="--reviewed")
        boolean reviewed;
        @Option(name="-q")
        String query;
        private final Provider<ReviewDb> db;
        private final Provider<CurrentUser> self;
        private final FileInfoJson fileInfoJson;
        private final Revisions revisions;
        private final GitRepositoryManager gitManager;
        private final PatchListCache patchListCache;
        private final PatchSetUtil psUtil;
        private final DynamicItem<AccountPatchReviewStore> accountPatchReviewStore;

        @Inject
        ListFiles(Provider<ReviewDb> db, Provider<CurrentUser> self, FileInfoJson fileInfoJson, Revisions revisions, GitRepositoryManager gitManager, PatchListCache patchListCache, PatchSetUtil psUtil, DynamicItem<AccountPatchReviewStore> accountPatchReviewStore) {
            this.db = db;
            this.self = self;
            this.fileInfoJson = fileInfoJson;
            this.revisions = revisions;
            this.gitManager = gitManager;
            this.patchListCache = patchListCache;
            this.psUtil = psUtil;
            this.accountPatchReviewStore = accountPatchReviewStore;
        }

        public ListFiles setReviewed(boolean r) {
            this.reviewed = r;
            return this;
        }

        public Response<?> apply(RevisionResource resource) throws AuthException, BadRequestException, ResourceNotFoundException, OrmException, RepositoryNotFoundException, IOException, PatchListNotAvailableException {
            Response<Map<String, FileInfo>> r;
            this.checkOptions();
            if (this.reviewed) {
                return Response.ok(this.reviewed(resource));
            }
            if (this.query != null) {
                return Response.ok(this.query(resource));
            }
            if (this.base != null) {
                RevisionResource baseResource = this.revisions.parse(resource.getChangeResource(), IdString.fromDecoded(this.base));
                r = Response.ok(this.fileInfoJson.toFileInfoMap(resource.getChange(), resource.getPatchSet().getRevision(), baseResource.getPatchSet()));
            } else {
                r = this.parentNum > 0 ? Response.ok(this.fileInfoJson.toFileInfoMap(resource.getChange(), resource.getPatchSet().getRevision(), this.parentNum - 1)) : Response.ok(this.fileInfoJson.toFileInfoMap(resource.getChange(), resource.getPatchSet()));
            }
            if (resource.isCacheable()) {
                r.caching(CacheControl.PRIVATE(7L, TimeUnit.DAYS));
            }
            return r;
        }

        private void checkOptions() throws BadRequestException {
            int supplied = 0;
            if (this.base != null) {
                ++supplied;
            }
            if (this.parentNum > 0) {
                ++supplied;
            }
            if (this.reviewed) {
                ++supplied;
            }
            if (this.query != null) {
                ++supplied;
            }
            if (supplied > 1) {
                throw new BadRequestException("cannot combine base, parent, reviewed, query");
            }
        }

        /*
         * Exception decompiling
         */
        private List<String> query(RevisionResource resource) throws RepositoryNotFoundException, IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private Collection<String> reviewed(RevisionResource resource) throws AuthException, OrmException {
            CurrentUser user = this.self.get();
            if (!user.isIdentifiedUser()) {
                throw new AuthException("Authentication required");
            }
            Account.Id userId = user.getAccountId();
            PatchSet patchSetId = resource.getPatchSet();
            Optional<AccountPatchReviewStore.PatchSetWithReviewedFiles> o = this.accountPatchReviewStore.get().findReviewed(patchSetId.getId(), userId);
            if (o.isPresent()) {
                AccountPatchReviewStore.PatchSetWithReviewedFiles res = o.get();
                if (res.patchSetId().equals(patchSetId.getId())) {
                    return res.files();
                }
                try {
                    return this.copy(res.files(), res.patchSetId(), resource, userId);
                }
                catch (PatchListNotAvailableException | IOException e) {
                    log.warn("Cannot copy patch review flags", e);
                }
            }
            return Collections.emptyList();
        }

        /*
         * Exception decompiling
         */
        private List<String> copy(Set<String> paths, PatchSet.Id old, RevisionResource resource, Account.Id userId) throws IOException, PatchListNotAvailableException, OrmException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public ListFiles setBase(String base) {
            this.base = base;
            return this;
        }

        public ListFiles setParent(int parentNum) {
            this.parentNum = parentNum;
            return this;
        }

        private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
            if (x0 != null) {
                try {
                    x1.close();
                }
                catch (Throwable throwable) {
                    x0.addSuppressed(throwable);
                }
            } else {
                x1.close();
            }
        }
    }
}

