/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class LimitedByteArrayOutputStream
extends OutputStream {
    private final int maxSize;
    private final ByteArrayOutputStream buffer;

    LimitedByteArrayOutputStream(int max, int initial) {
        Preconditions.checkArgument(initial <= max);
        this.maxSize = max;
        this.buffer = new ByteArrayOutputStream(initial);
    }

    private void checkOversize(int additionalSize) throws IOException {
        if (this.buffer.size() + additionalSize > this.maxSize) {
            throw new LimitExceededException();
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.checkOversize(1);
        this.buffer.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkOversize(len);
        this.buffer.write(b, off, len);
    }

    public byte[] toByteArray() {
        return this.buffer.toByteArray();
    }

    static class LimitExceededException
    extends IOException {
        private static final long serialVersionUID = 1L;

        LimitExceededException() {
        }
    }
}

