/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.extensions.api.changes.AddReviewerInput;
import com.google.gerrit.extensions.api.changes.AssigneeInput;
import com.google.gerrit.extensions.api.changes.NotifyHandling;
import com.google.gerrit.extensions.client.ReviewerState;
import com.google.gerrit.extensions.common.AccountInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.webui.UiAction;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.account.AccountLoader;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.PostReviewers;
import com.google.gerrit.server.change.SetAssigneeOp;
import com.google.gerrit.server.update.BatchUpdate;
import com.google.gerrit.server.update.UpdateException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;

@Singleton
public class PutAssignee
implements RestModifyView<ChangeResource, AssigneeInput>,
UiAction<ChangeResource> {
    private final SetAssigneeOp.Factory assigneeFactory;
    private final BatchUpdate.Factory batchUpdateFactory;
    private final Provider<ReviewDb> db;
    private final PostReviewers postReviewers;
    private final AccountLoader.Factory accountLoaderFactory;

    @Inject
    PutAssignee(SetAssigneeOp.Factory assigneeFactory, BatchUpdate.Factory batchUpdateFactory, Provider<ReviewDb> db, PostReviewers postReviewers, AccountLoader.Factory accountLoaderFactory) {
        this.assigneeFactory = assigneeFactory;
        this.batchUpdateFactory = batchUpdateFactory;
        this.db = db;
        this.postReviewers = postReviewers;
        this.accountLoaderFactory = accountLoaderFactory;
    }

    public Response<AccountInfo> apply(ChangeResource rsrc, AssigneeInput input) throws RestApiException, UpdateException, OrmException, IOException {
        if (!rsrc.getControl().canEditAssignee()) {
            throw new AuthException("Changing Assignee not permitted");
        }
        if (input.assignee == null || input.assignee.trim().isEmpty()) {
            throw new BadRequestException("missing assignee field");
        }
        try (BatchUpdate bu = this.batchUpdateFactory.create(this.db.get(), rsrc.getChange().getProject(), rsrc.getControl().getUser(), TimeUtil.nowTs());){
            SetAssigneeOp op = this.assigneeFactory.create(input.assignee);
            bu.addOp(rsrc.getId(), op);
            PostReviewers.Addition reviewersAddition = this.addAssigneeAsCC(rsrc, input.assignee);
            bu.addOp(rsrc.getId(), reviewersAddition.op);
            bu.execute();
            Response<AccountInfo> response = Response.ok(this.accountLoaderFactory.create(true).fillOne(op.getNewAssignee()));
            return response;
        }
    }

    private PostReviewers.Addition addAssigneeAsCC(ChangeResource rsrc, String assignee) throws OrmException, RestApiException, IOException {
        AddReviewerInput reviewerInput = new AddReviewerInput();
        reviewerInput.reviewer = assignee;
        reviewerInput.state = ReviewerState.CC;
        reviewerInput.confirmed = true;
        reviewerInput.notify = NotifyHandling.NONE;
        return this.postReviewers.prepareApplication(rsrc, reviewerInput, false);
    }

    @Override
    public UiAction.Description getDescription(ChangeResource resource) {
        return new UiAction.Description().setLabel("Edit Assignee").setVisible(resource.getControl().canEditAssignee());
    }
}

