/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.restapi.RestResource;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.project.ChangeControl;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;

public class ReviewerResource
implements RestResource {
    public static final TypeLiteral<RestView<ReviewerResource>> REVIEWER_KIND = new TypeLiteral<RestView<ReviewerResource>>(){};
    private final ChangeResource change;
    private final RevisionResource revision;
    private final IdentifiedUser user;

    @AssistedInject
    ReviewerResource(IdentifiedUser.GenericFactory userFactory, @Assisted ChangeResource change, @Assisted Account.Id id) {
        this.change = change;
        this.revision = null;
        this.user = userFactory.create(id);
    }

    @AssistedInject
    ReviewerResource(IdentifiedUser.GenericFactory userFactory, @Assisted RevisionResource revision, @Assisted Account.Id id) {
        this.revision = revision;
        this.change = revision.getChangeResource();
        this.user = userFactory.create(id);
    }

    public ChangeResource getChangeResource() {
        return this.change;
    }

    public RevisionResource getRevisionResource() {
        return this.revision;
    }

    public Change.Id getChangeId() {
        return this.change.getId();
    }

    public Change getChange() {
        return this.change.getChange();
    }

    public IdentifiedUser getReviewerUser() {
        return this.user;
    }

    public ChangeControl getControl() {
        return this.change.getControl();
    }

    public ChangeControl getReviewerControl() {
        return this.change.getControl().forUser(this.user);
    }

    public static interface Factory {
        public ReviewerResource create(ChangeResource var1, Account.Id var2);

        public ReviewerResource create(RevisionResource var1, Account.Id var2);
    }
}

