/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.collect.ImmutableSet;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ChildCollection;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.account.AccountsCollection;
import com.google.gerrit.server.change.ListRevisionReviewers;
import com.google.gerrit.server.change.ReviewerResource;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;

@Singleton
public class RevisionReviewers
implements ChildCollection<RevisionResource, ReviewerResource> {
    private final DynamicMap<RestView<ReviewerResource>> views;
    private final Provider<ReviewDb> dbProvider;
    private final ApprovalsUtil approvalsUtil;
    private final AccountsCollection accounts;
    private final ReviewerResource.Factory resourceFactory;
    private final ListRevisionReviewers list;

    @Inject
    RevisionReviewers(Provider<ReviewDb> dbProvider, ApprovalsUtil approvalsUtil, AccountsCollection accounts, ReviewerResource.Factory resourceFactory, DynamicMap<RestView<ReviewerResource>> views, ListRevisionReviewers list) {
        this.dbProvider = dbProvider;
        this.approvalsUtil = approvalsUtil;
        this.accounts = accounts;
        this.resourceFactory = resourceFactory;
        this.views = views;
        this.list = list;
    }

    @Override
    public DynamicMap<RestView<ReviewerResource>> views() {
        return this.views;
    }

    @Override
    public RestView<RevisionResource> list() {
        return this.list;
    }

    @Override
    public ReviewerResource parse(RevisionResource rsrc, IdString id) throws OrmException, ResourceNotFoundException, AuthException, MethodNotAllowedException {
        if (!rsrc.isCurrent()) {
            throw new MethodNotAllowedException("Cannot access on non-current patch set");
        }
        Account.Id accountId = this.accounts.parse(TopLevelResource.INSTANCE, id).getUser().getAccountId();
        ImmutableSet<Account.Id> reviewers = this.approvalsUtil.getReviewers(this.dbProvider.get(), rsrc.getNotes()).all();
        if (reviewers.contains(accountId)) {
            return this.resourceFactory.create(rsrc, accountId);
        }
        throw new ResourceNotFoundException(id);
    }
}

