/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.ScheduleConfig;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.jgit.lib.Config;

@Singleton
public class GcConfig {
    private final ScheduleConfig scheduleConfig;
    private final boolean aggressive;

    @Inject
    GcConfig(@GerritServerConfig Config cfg) {
        this.scheduleConfig = new ScheduleConfig(cfg, "gc");
        this.aggressive = cfg.getBoolean("gc", "aggressive", false);
    }

    public ScheduleConfig getScheduleConfig() {
        return this.scheduleConfig;
    }

    public boolean isAggressive() {
        return this.aggressive;
    }
}

