/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.gerrit.server.config.GerritConfig;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.securestore.SecureStore;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GerritServerConfigProvider
implements Provider<Config> {
    private static final Logger log = LoggerFactory.getLogger(GerritServerConfigProvider.class);
    private final SitePaths site;
    private final SecureStore secureStore;

    @Inject
    GerritServerConfigProvider(SitePaths site, SecureStore secureStore) {
        this.site = site;
        this.secureStore = secureStore;
    }

    @Override
    public Config get() {
        FileBasedConfig cfg = new FileBasedConfig(this.site.gerrit_config.toFile(), FS.DETECTED);
        if (!cfg.getFile().exists()) {
            log.info("No " + this.site.gerrit_config.toAbsolutePath() + "; assuming defaults");
            return new GerritConfig(cfg, this.secureStore);
        }
        try {
            cfg.load();
        }
        catch (IOException | ConfigInvalidException e) {
            throw new ProvisionException(e.getMessage(), e);
        }
        return new GerritConfig(cfg, this.secureStore);
    }
}

