/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.gerrit.extensions.client.GeneralPreferencesInfo;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.server.account.GeneralPreferencesLoader;
import com.google.gerrit.server.account.VersionedAccountPreferences;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.config.ConfigResource;
import com.google.gerrit.server.config.ConfigUtil;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.Repository;

@Singleton
public class GetPreferences
implements RestReadView<ConfigResource> {
    private final GeneralPreferencesLoader loader;
    private final GitRepositoryManager gitMgr;
    private final AllUsersName allUsersName;

    @Inject
    public GetPreferences(GeneralPreferencesLoader loader, GitRepositoryManager gitMgr, AllUsersName allUsersName) {
        this.loader = loader;
        this.gitMgr = gitMgr;
        this.allUsersName = allUsersName;
    }

    public GeneralPreferencesInfo apply(ConfigResource rsrc) throws IOException, ConfigInvalidException {
        return GetPreferences.readFromGit(this.gitMgr, this.loader, this.allUsersName, null);
    }

    static GeneralPreferencesInfo readFromGit(GitRepositoryManager gitMgr, GeneralPreferencesLoader loader, AllUsersName allUsersName, GeneralPreferencesInfo in) throws IOException, ConfigInvalidException, RepositoryNotFoundException {
        try (Repository git = gitMgr.openRepository(allUsersName);){
            VersionedAccountPreferences p = VersionedAccountPreferences.forDefault();
            p.load(git);
            GeneralPreferencesInfo r = ConfigUtil.loadSection(p.getConfig(), "general", null, new GeneralPreferencesInfo(), GeneralPreferencesInfo.defaults(), in);
            GeneralPreferencesInfo generalPreferencesInfo = loader.loadMyMenusAndUrlAliases(r, p, null);
            return generalPreferencesInfo;
        }
    }
}

