/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.gerrit.common.data.ContributorAgreement;
import com.google.gerrit.extensions.client.AccountFieldName;
import com.google.gerrit.extensions.client.UiType;
import com.google.gerrit.extensions.common.AuthInfo;
import com.google.gerrit.extensions.common.ChangeConfigInfo;
import com.google.gerrit.extensions.common.DownloadInfo;
import com.google.gerrit.extensions.common.DownloadSchemeInfo;
import com.google.gerrit.extensions.common.GerritInfo;
import com.google.gerrit.extensions.common.PluginConfigInfo;
import com.google.gerrit.extensions.common.ReceiveInfo;
import com.google.gerrit.extensions.common.ServerInfo;
import com.google.gerrit.extensions.common.SshdInfo;
import com.google.gerrit.extensions.common.SuggestInfo;
import com.google.gerrit.extensions.common.UserConfigInfo;
import com.google.gerrit.extensions.config.CloneCommand;
import com.google.gerrit.extensions.config.DownloadCommand;
import com.google.gerrit.extensions.config.DownloadScheme;
import com.google.gerrit.extensions.registration.DynamicItem;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.extensions.webui.WebUiPlugin;
import com.google.gerrit.server.EnableSignedPush;
import com.google.gerrit.server.account.Realm;
import com.google.gerrit.server.avatar.AvatarProvider;
import com.google.gerrit.server.change.AllowedFormats;
import com.google.gerrit.server.change.ArchiveFormat;
import com.google.gerrit.server.change.Submit;
import com.google.gerrit.server.config.AgreementJson;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.config.AnonymousCowardName;
import com.google.gerrit.server.config.AuthConfig;
import com.google.gerrit.server.config.ConfigResource;
import com.google.gerrit.server.config.ConfigUtil;
import com.google.gerrit.server.config.GerritOptions;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.documentation.QueryDocumentationExecutor;
import com.google.gerrit.server.index.change.ChangeField;
import com.google.gerrit.server.index.change.ChangeIndex;
import com.google.gerrit.server.index.change.ChangeIndexCollection;
import com.google.gerrit.server.notedb.NotesMigration;
import com.google.gerrit.server.project.ProjectCache;
import com.google.inject.Inject;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.jgit.lib.Config;

public class GetServerInfo
implements RestReadView<ConfigResource> {
    private static final String URL_ALIAS = "urlAlias";
    private static final String KEY_MATCH = "match";
    private static final String KEY_TOKEN = "token";
    private final Config config;
    private final AuthConfig authConfig;
    private final Realm realm;
    private final DynamicMap<DownloadScheme> downloadSchemes;
    private final DynamicMap<DownloadCommand> downloadCommands;
    private final DynamicMap<CloneCommand> cloneCommands;
    private final DynamicSet<WebUiPlugin> plugins;
    private final AllowedFormats archiveFormats;
    private final AllProjectsName allProjectsName;
    private final AllUsersName allUsersName;
    private final String anonymousCowardName;
    private final DynamicItem<AvatarProvider> avatar;
    private final boolean enableSignedPush;
    private final QueryDocumentationExecutor docSearcher;
    private final NotesMigration migration;
    private final ProjectCache projectCache;
    private final AgreementJson agreementJson;
    private final GerritOptions gerritOptions;
    private final ChangeIndexCollection indexes;

    @Inject
    public GetServerInfo(@GerritServerConfig Config config, AuthConfig authConfig, Realm realm, DynamicMap<DownloadScheme> downloadSchemes, DynamicMap<DownloadCommand> downloadCommands, DynamicMap<CloneCommand> cloneCommands, DynamicSet<WebUiPlugin> webUiPlugins, AllowedFormats archiveFormats, AllProjectsName allProjectsName, AllUsersName allUsersName, @AnonymousCowardName String anonymousCowardName, DynamicItem<AvatarProvider> avatar, @EnableSignedPush boolean enableSignedPush, QueryDocumentationExecutor docSearcher, NotesMigration migration, ProjectCache projectCache, AgreementJson agreementJson, GerritOptions gerritOptions, ChangeIndexCollection indexes) {
        this.config = config;
        this.authConfig = authConfig;
        this.realm = realm;
        this.downloadSchemes = downloadSchemes;
        this.downloadCommands = downloadCommands;
        this.cloneCommands = cloneCommands;
        this.plugins = webUiPlugins;
        this.archiveFormats = archiveFormats;
        this.allProjectsName = allProjectsName;
        this.allUsersName = allUsersName;
        this.anonymousCowardName = anonymousCowardName;
        this.avatar = avatar;
        this.enableSignedPush = enableSignedPush;
        this.docSearcher = docSearcher;
        this.migration = migration;
        this.projectCache = projectCache;
        this.agreementJson = agreementJson;
        this.gerritOptions = gerritOptions;
        this.indexes = indexes;
    }

    public ServerInfo apply(ConfigResource rsrc) throws MalformedURLException {
        ServerInfo info = new ServerInfo();
        info.auth = this.getAuthInfo(this.authConfig, this.realm);
        info.change = this.getChangeInfo(this.config);
        info.download = this.getDownloadInfo(this.downloadSchemes, this.downloadCommands, this.cloneCommands, this.archiveFormats);
        info.gerrit = this.getGerritInfo(this.config, this.allProjectsName, this.allUsersName);
        info.noteDbEnabled = GetServerInfo.toBoolean(this.isNoteDbEnabled());
        info.plugin = this.getPluginInfo();
        info.sshd = this.getSshdInfo(this.config);
        info.suggest = this.getSuggestInfo(this.config);
        Map<String, String> urlAliases = this.getUrlAliasesInfo(this.config);
        info.urlAliases = !urlAliases.isEmpty() ? urlAliases : null;
        info.user = this.getUserInfo(this.anonymousCowardName);
        info.receive = this.getReceiveInfo();
        return info;
    }

    private AuthInfo getAuthInfo(AuthConfig cfg, Realm realm) {
        Collection<ContributorAgreement> agreements;
        AuthInfo info = new AuthInfo();
        info.authType = cfg.getAuthType();
        info.useContributorAgreements = GetServerInfo.toBoolean(cfg.isUseContributorAgreements());
        info.editableAccountFields = new ArrayList<AccountFieldName>(realm.getEditableFields());
        info.switchAccountUrl = cfg.getSwitchAccountUrl();
        info.gitBasicAuthPolicy = cfg.getGitBasicAuthPolicy();
        if (info.useContributorAgreements != null && !(agreements = this.projectCache.getAllProjects().getConfig().getContributorAgreements()).isEmpty()) {
            info.contributorAgreements = Lists.newArrayListWithCapacity(agreements.size());
            for (ContributorAgreement agreement : agreements) {
                info.contributorAgreements.add(this.agreementJson.format(agreement));
            }
        }
        switch (info.authType) {
            case LDAP: 
            case LDAP_BIND: {
                info.registerUrl = cfg.getRegisterUrl();
                info.registerText = cfg.getRegisterText();
                info.editFullNameUrl = cfg.getEditFullNameUrl();
                break;
            }
            case CUSTOM_EXTENSION: {
                info.registerUrl = cfg.getRegisterUrl();
                info.registerText = cfg.getRegisterText();
                info.editFullNameUrl = cfg.getEditFullNameUrl();
                info.httpPasswordUrl = cfg.getHttpPasswordUrl();
                break;
            }
            case HTTP: 
            case HTTP_LDAP: {
                info.loginUrl = cfg.getLoginUrl();
                info.loginText = cfg.getLoginText();
                break;
            }
        }
        return info;
    }

    private ChangeConfigInfo getChangeInfo(Config cfg) {
        ChangeConfigInfo info = new ChangeConfigInfo();
        info.allowBlame = GetServerInfo.toBoolean(cfg.getBoolean("change", "allowBlame", true));
        info.allowDrafts = GetServerInfo.toBoolean(cfg.getBoolean("change", "allowDrafts", true));
        boolean hasAssigneeInIndex = ((ChangeIndex)this.indexes.getSearchIndex()).getSchema().hasField(ChangeField.ASSIGNEE);
        info.showAssigneeInChangesTable = GetServerInfo.toBoolean(cfg.getBoolean("change", "showAssigneeInChangesTable", false) && hasAssigneeInIndex);
        info.largeChange = cfg.getInt("change", "largeChange", 500);
        info.replyTooltip = Optional.ofNullable(cfg.getString("change", null, "replyTooltip")).orElse("Reply and score") + " (Shortcut: a)";
        info.replyLabel = Optional.ofNullable(cfg.getString("change", null, "replyLabel")).orElse("Reply") + "\u2026";
        info.updateDelay = (int)ConfigUtil.getTimeUnit(cfg, "change", null, "updateDelay", 30L, TimeUnit.SECONDS);
        info.submitWholeTopic = Submit.wholeTopicEnabled(cfg);
        return info;
    }

    private DownloadInfo getDownloadInfo(DynamicMap<DownloadScheme> downloadSchemes, DynamicMap<DownloadCommand> downloadCommands, DynamicMap<CloneCommand> cloneCommands, AllowedFormats archiveFormats) {
        DownloadInfo info = new DownloadInfo();
        info.schemes = new HashMap<String, DownloadSchemeInfo>();
        for (DynamicMap.Entry<DownloadScheme> entry : downloadSchemes) {
            DownloadScheme scheme = entry.getProvider().get();
            if (!scheme.isEnabled() || scheme.getUrl("${project}") == null) continue;
            info.schemes.put(entry.getExportName(), this.getDownloadSchemeInfo(scheme, downloadCommands, cloneCommands));
        }
        info.archives = archiveFormats.getAllowed().stream().map(ArchiveFormat::getShortName).collect(Collectors.toList());
        return info;
    }

    private DownloadSchemeInfo getDownloadSchemeInfo(DownloadScheme scheme, DynamicMap<DownloadCommand> downloadCommands, DynamicMap<CloneCommand> cloneCommands) {
        String c;
        Object command;
        String commandName;
        DownloadSchemeInfo info = new DownloadSchemeInfo();
        info.url = scheme.getUrl("${project}");
        info.isAuthRequired = GetServerInfo.toBoolean(scheme.isAuthRequired());
        info.isAuthSupported = GetServerInfo.toBoolean(scheme.isAuthSupported());
        info.commands = new HashMap<String, String>();
        for (DynamicMap.Entry<DownloadCommand> entry : downloadCommands) {
            commandName = entry.getExportName();
            command = entry.getProvider().get();
            c = ((DownloadCommand)command).getCommand(scheme, "${project}", "${ref}");
            if (c == null) continue;
            info.commands.put(commandName, c);
        }
        info.cloneCommands = new HashMap<String, String>();
        for (DynamicMap.Entry<Object> entry : cloneCommands) {
            commandName = entry.getExportName();
            command = (CloneCommand)entry.getProvider().get();
            c = ((CloneCommand)command).getCommand(scheme, "${project-path}/${project-base-name}");
            if (c == null) continue;
            c = c.replaceAll("\\$\\{project-path\\}/\\$\\{project-base-name\\}", "\\$\\{project\\}");
            info.cloneCommands.put(commandName, c);
        }
        return info;
    }

    private GerritInfo getGerritInfo(Config cfg, AllProjectsName allProjectsName, AllUsersName allUsersName) {
        GerritInfo info = new GerritInfo();
        info.allProjects = allProjectsName.get();
        info.allUsers = allUsersName.get();
        info.reportBugUrl = cfg.getString("gerrit", null, "reportBugUrl");
        info.reportBugText = cfg.getString("gerrit", null, "reportBugText");
        info.docUrl = this.getDocUrl(cfg);
        info.docSearch = this.docSearcher.isAvailable();
        info.editGpgKeys = GetServerInfo.toBoolean(this.enableSignedPush && cfg.getBoolean("gerrit", null, "editGpgKeys", true));
        info.webUis = EnumSet.noneOf(UiType.class);
        if (this.gerritOptions.enableGwtUi()) {
            info.webUis.add(UiType.GWT);
        }
        if (this.gerritOptions.enablePolyGerrit()) {
            info.webUis.add(UiType.POLYGERRIT);
        }
        return info;
    }

    private String getDocUrl(Config cfg) {
        String docUrl = cfg.getString("gerrit", null, "docUrl");
        if (Strings.isNullOrEmpty(docUrl)) {
            return null;
        }
        return CharMatcher.is('/').trimTrailingFrom(docUrl) + '/';
    }

    private boolean isNoteDbEnabled() {
        return this.migration.readChanges();
    }

    private PluginConfigInfo getPluginInfo() {
        PluginConfigInfo info = new PluginConfigInfo();
        info.hasAvatars = GetServerInfo.toBoolean(this.avatar.get() != null);
        info.jsResourcePaths = new ArrayList<String>();
        for (WebUiPlugin u : this.plugins) {
            info.jsResourcePaths.add(String.format("plugins/%s/%s", u.getPluginName(), u.getJavaScriptResourcePath()));
        }
        return info;
    }

    private Map<String, String> getUrlAliasesInfo(Config cfg) {
        HashMap<String, String> urlAliases = new HashMap<String, String>();
        for (String subsection : cfg.getSubsections(URL_ALIAS)) {
            urlAliases.put(cfg.getString(URL_ALIAS, subsection, KEY_MATCH), cfg.getString(URL_ALIAS, subsection, KEY_TOKEN));
        }
        return urlAliases;
    }

    private SshdInfo getSshdInfo(Config cfg) {
        String[] addr = cfg.getStringList("sshd", null, "listenAddress");
        if (addr.length == 1 && GetServerInfo.isOff(addr[0])) {
            return null;
        }
        return new SshdInfo();
    }

    private static boolean isOff(String listenHostname) {
        return "off".equalsIgnoreCase(listenHostname) || "none".equalsIgnoreCase(listenHostname) || "no".equalsIgnoreCase(listenHostname);
    }

    private SuggestInfo getSuggestInfo(Config cfg) {
        SuggestInfo info = new SuggestInfo();
        info.from = cfg.getInt("suggest", "from", 0);
        return info;
    }

    private UserConfigInfo getUserInfo(String anonymousCowardName) {
        UserConfigInfo info = new UserConfigInfo();
        info.anonymousCowardName = anonymousCowardName;
        return info;
    }

    private ReceiveInfo getReceiveInfo() {
        ReceiveInfo info = new ReceiveInfo();
        info.enableSignedPush = this.enableSignedPush;
        return info;
    }

    private static Boolean toBoolean(boolean v) {
        return v ? Boolean.valueOf(v) : null;
    }
}

