/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.edit.tree;

import com.google.common.base.Preconditions;
import com.google.gerrit.server.edit.tree.TreeModification;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;

public class TreeCreator {
    private final RevCommit baseCommit;
    private final List<TreeModification> treeModifications = new ArrayList<TreeModification>();

    public TreeCreator(RevCommit baseCommit) {
        this.baseCommit = Preconditions.checkNotNull(baseCommit, "baseCommit is required");
    }

    public void addTreeModification(TreeModification treeModification) {
        Preconditions.checkNotNull(treeModification, "treeModification must not be null");
        this.treeModifications.add(treeModification);
    }

    public ObjectId createNewTreeAndGetId(Repository repository) throws IOException {
        DirCache newTree = this.createNewTree(repository);
        return TreeCreator.writeAndGetId(repository, newTree);
    }

    private DirCache createNewTree(Repository repository) throws IOException {
        DirCache newTree = this.readBaseTree(repository);
        List<DirCacheEditor.PathEdit> pathEdits = this.getPathEdits(repository);
        TreeCreator.applyPathEdits(newTree, pathEdits);
        return newTree;
    }

    private DirCache readBaseTree(Repository repository) throws IOException {
        try (ObjectReader objectReader = repository.newObjectReader();){
            DirCache dirCache = DirCache.newInCore();
            DirCacheBuilder dirCacheBuilder = dirCache.builder();
            dirCacheBuilder.addTree(new byte[0], 0, objectReader, this.baseCommit.getTree());
            dirCacheBuilder.finish();
            DirCache dirCache2 = dirCache;
            return dirCache2;
        }
    }

    private List<DirCacheEditor.PathEdit> getPathEdits(Repository repository) throws IOException {
        ArrayList<DirCacheEditor.PathEdit> pathEdits = new ArrayList<DirCacheEditor.PathEdit>();
        for (TreeModification treeModification : this.treeModifications) {
            pathEdits.addAll(treeModification.getPathEdits(repository, this.baseCommit));
        }
        return pathEdits;
    }

    private static void applyPathEdits(DirCache tree, List<DirCacheEditor.PathEdit> pathEdits) {
        DirCacheEditor dirCacheEditor = tree.editor();
        pathEdits.forEach(dirCacheEditor::add);
        dirCacheEditor.finish();
    }

    private static ObjectId writeAndGetId(Repository repository, DirCache tree) throws IOException {
        try (ObjectInserter objectInserter = repository.newObjectInserter();){
            ObjectId treeId = tree.writeTree(objectInserter);
            objectInserter.flush();
            ObjectId objectId = treeId;
            return objectId;
        }
    }
}

