/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.extensions.events;

import com.google.gerrit.extensions.common.AccountInfo;
import com.google.gerrit.extensions.events.AgreementSignupListener;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.extensions.events.AbstractNoNotifyEvent;
import com.google.gerrit.server.extensions.events.EventUtil;
import com.google.inject.Inject;
import com.google.inject.Singleton;

@Singleton
public class AgreementSignup {
    private final DynamicSet<AgreementSignupListener> listeners;
    private final EventUtil util;

    @Inject
    AgreementSignup(DynamicSet<AgreementSignupListener> listeners, EventUtil util) {
        this.listeners = listeners;
        this.util = util;
    }

    public void fire(Account account, String agreementName) {
        if (!this.listeners.iterator().hasNext()) {
            return;
        }
        Event event = new Event(this.util.accountInfo(account), agreementName);
        for (AgreementSignupListener l : this.listeners) {
            try {
                l.onAgreementSignup(event);
            }
            catch (Exception e) {
                this.util.logEventListenerError(this, l, e);
            }
        }
    }

    private static class Event
    extends AbstractNoNotifyEvent
    implements AgreementSignupListener.Event {
        private final AccountInfo account;
        private final String agreementName;

        Event(AccountInfo account, String agreementName) {
            this.account = account;
            this.agreementName = agreementName;
        }

        @Override
        public AccountInfo getAccount() {
            return this.account;
        }

        @Override
        public String getAgreementName() {
            return this.agreementName;
        }
    }
}

