/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.extensions.events;

import com.google.gerrit.extensions.api.changes.NotifyHandling;
import com.google.gerrit.extensions.common.AccountInfo;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.common.RevisionInfo;
import com.google.gerrit.extensions.events.DraftPublishedListener;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.server.GpgException;
import com.google.gerrit.server.extensions.events.AbstractRevisionEvent;
import com.google.gerrit.server.extensions.events.EventUtil;
import com.google.gerrit.server.patch.PatchListNotAvailableException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.sql.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DraftPublished {
    private static final Logger log = LoggerFactory.getLogger(DraftPublished.class);
    private final DynamicSet<DraftPublishedListener> listeners;
    private final EventUtil util;

    @Inject
    public DraftPublished(DynamicSet<DraftPublishedListener> listeners, EventUtil util) {
        this.listeners = listeners;
        this.util = util;
    }

    public void fire(Change change, PatchSet patchSet, Account accountId, Timestamp when) {
        try {
            Event event = new Event(this.util.changeInfo(change), this.util.revisionInfo(change.getProject(), patchSet), this.util.accountInfo(accountId), when);
            for (DraftPublishedListener l : this.listeners) {
                try {
                    l.onDraftPublished(event);
                }
                catch (Exception e) {
                    this.util.logEventListenerError(this, l, e);
                }
            }
        }
        catch (GpgException | PatchListNotAvailableException | OrmException | IOException e) {
            log.error("Couldn't fire event", e);
        }
    }

    private static class Event
    extends AbstractRevisionEvent
    implements DraftPublishedListener.Event {
        Event(ChangeInfo change, RevisionInfo revision, AccountInfo publisher, Timestamp when) {
            super(change, revision, publisher, when, NotifyHandling.ALL);
        }
    }
}

